/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections;

import de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections.CollectionDeserializer;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import java.lang.reflect.Array;
import java.util.List;

public final class ArrayCollectionDeserializer
implements CollectionDeserializer {
    private final ResolvedType componentType;

    public static CollectionDeserializer arrayDeserializer(ResolvedType componentType) {
        return new ArrayCollectionDeserializer(componentType);
    }

    @Override
    public TypeIdentifier contentType() {
        return RealTypeIdentifier.realTypeIdentifier(this.componentType);
    }

    @Override
    public Object deserialize(List<Object> deserializedElements) {
        int size = deserializedElements.size();
        Object[] array = (Object[])Array.newInstance(this.componentType.assignableType(), size);
        for (int i = 0; i < size; ++i) {
            array[i] = deserializedElements.get(i);
        }
        return array;
    }

    @Override
    public String description() {
        return "array deserialization";
    }

    public String toString() {
        return "ArrayCollectionDeserializer(componentType=" + this.componentType + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayCollectionDeserializer)) {
            return false;
        }
        ArrayCollectionDeserializer other = (ArrayCollectionDeserializer)o;
        ResolvedType this$componentType = this.componentType;
        ResolvedType other$componentType = other.componentType;
        return !(this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $componentType = this.componentType;
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        return result;
    }

    private ArrayCollectionDeserializer(ResolvedType componentType) {
        this.componentType = componentType;
    }
}

