/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections;

import de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections.CollectionDeserializer;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public final class ListCollectionDeserializer
implements CollectionDeserializer {
    private final ResolvedType componentType;
    private final Function<List<Object>, Collection<Object>> mapper;

    public static CollectionDeserializer listDeserializer(ResolvedType componentType, Function<List<Object>, Collection<Object>> mapper) {
        NotNullValidator.validateNotNull(componentType, "componentType");
        NotNullValidator.validateNotNull(mapper, "mapper");
        return new ListCollectionDeserializer(componentType, mapper);
    }

    @Override
    public Object deserialize(List<Object> deserializedElements) {
        return this.mapper.apply(deserializedElements);
    }

    @Override
    public TypeIdentifier contentType() {
        return RealTypeIdentifier.realTypeIdentifier(this.componentType);
    }

    @Override
    public String description() {
        return String.format("deserializing a collection with content type '%s'", this.componentType.description());
    }

    public String toString() {
        return "ListCollectionDeserializer(componentType=" + this.componentType + ", mapper=" + this.mapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListCollectionDeserializer)) {
            return false;
        }
        ListCollectionDeserializer other = (ListCollectionDeserializer)o;
        ResolvedType this$componentType = this.componentType;
        ResolvedType other$componentType = other.componentType;
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        Function<List<Object>, Collection<Object>> this$mapper = this.mapper;
        Function<List<Object>, Collection<Object>> other$mapper = other.mapper;
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $componentType = this.componentType;
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        Function<List<Object>, Collection<Object>> $mapper = this.mapper;
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    private ListCollectionDeserializer(ResolvedType componentType, Function<List<Object>, Collection<Object>> mapper) {
        this.componentType = componentType;
        this.mapper = mapper;
    }
}

