/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives;

import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.IncompatibleCustomPrimitiveException;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializationMethodCallException;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedParameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;

public final class CustomPrimitiveByMethodDeserializer
implements CustomPrimitiveDeserializer {
    private final ResolvedType baseType;
    private final ResolvedMethod deserializationMethod;

    public static TypeDeserializer createDeserializer(ResolvedType type, ResolvedMethod deserializationMethod) {
        int deserializationMethodModifiers = deserializationMethod.method().getModifiers();
        if (!Modifier.isStatic(deserializationMethodModifiers)) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The deserialization method %s configured for the custom primitive of type %s must be static", deserializationMethod.describe(), type.description());
        }
        if (Modifier.isAbstract(deserializationMethodModifiers)) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The deserialization method %s configured for the custom primitive of type %s must not be abstract", deserializationMethod.describe(), type.description());
        }
        List<ResolvedParameter> parameters = deserializationMethod.parameters();
        if (parameters.size() != 1) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The deserialization method %s configured for the custom primitive of type %s must accept only one parameter", deserializationMethod.describe(), type.description());
        }
        Boolean correctReturnType = deserializationMethod.returnType().map(type::equals).orElse(false);
        if (!correctReturnType.booleanValue()) {
            throw IncompatibleCustomPrimitiveException.incompatibleCustomPrimitiveException("The deserialization method %s configured for the custom primitive of type %s must return the custom primitive", deserializationMethod.describe(), type.description());
        }
        ResolvedType baseType = parameters.get(0).type();
        return new CustomPrimitiveByMethodDeserializer(baseType, deserializationMethod);
    }

    @Override
    public Class<?> baseType() {
        return this.baseType.assignableType();
    }

    @Override
    public Object deserialize(Object value) throws Exception {
        try {
            return this.deserializationMethod.method().invoke(null, value);
        }
        catch (IllegalAccessException e) {
            throw CustomPrimitiveSerializationMethodCallException.customPrimitiveSerializationMethodCallException(String.format("Unexpected error invoking deserialization method %s for serialized custom primitive %s", this.deserializationMethod, value), e);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(e, value);
        }
    }

    public ResolvedMethod method() {
        return this.deserializationMethod;
    }

    @Override
    public String description() {
        return CustomPrimitiveDeserializer.createDescription(this, this.deserializationMethod.describe());
    }

    private Exception handleInvocationTargetException(InvocationTargetException e, Object value) {
        Throwable targetException = e.getTargetException();
        if (targetException instanceof Exception) {
            return (Exception)targetException;
        }
        throw CustomPrimitiveSerializationMethodCallException.customPrimitiveSerializationMethodCallException(String.format("Unexpected error invoking deserialization method %s for serialized custom primitive %s", this.deserializationMethod, value), e);
    }

    public String toString() {
        return "CustomPrimitiveByMethodDeserializer(baseType=" + this.baseType + ", deserializationMethod=" + this.deserializationMethod + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveByMethodDeserializer)) {
            return false;
        }
        CustomPrimitiveByMethodDeserializer other = (CustomPrimitiveByMethodDeserializer)o;
        ResolvedType this$baseType = this.baseType;
        ResolvedType other$baseType = other.baseType;
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        ResolvedMethod this$deserializationMethod = this.deserializationMethod;
        ResolvedMethod other$deserializationMethod = other.deserializationMethod;
        return !(this$deserializationMethod == null ? other$deserializationMethod != null : !((Object)this$deserializationMethod).equals(other$deserializationMethod));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $baseType = this.baseType;
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        ResolvedMethod $deserializationMethod = this.deserializationMethod;
        result = result * 59 + ($deserializationMethod == null ? 43 : ((Object)$deserializationMethod).hashCode());
        return result;
    }

    private CustomPrimitiveByMethodDeserializer(ResolvedType baseType, ResolvedMethod deserializationMethod) {
        this.baseType = baseType;
        this.deserializationMethod = deserializationMethod;
    }
}

