/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects;

import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.IncompatibleSerializedObjectException;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedParameter;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MethodSerializedObjectDeserializer
implements SerializedObjectDeserializer {
    private final DeserializationFields fields;
    private final ResolvedMethod factoryMethod;
    private final List<String> parameterNames;

    public static SerializedObjectDeserializer methodDeserializer(ClassType type, ResolvedMethod deserializationMethod) {
        MethodSerializedObjectDeserializer.validateDeserializerModifiers(type, deserializationMethod);
        return MethodSerializedObjectDeserializer.verifiedDeserializationDTOMethod(deserializationMethod);
    }

    private static MethodSerializedObjectDeserializer verifiedDeserializationDTOMethod(ResolvedMethod factoryMethod) {
        List<ResolvedParameter> parameters = factoryMethod.parameters();
        List<String> parameterNames = parameters.stream().map(ResolvedParameter::parameter).map(Parameter::getName).collect(Collectors.toList());
        Map<String, TypeIdentifier> parameterFields = parameters.stream().collect(Collectors.toMap(ResolvedParameter::name, resolvedParameter -> RealTypeIdentifier.realTypeIdentifier(resolvedParameter.type())));
        return new MethodSerializedObjectDeserializer(DeserializationFields.deserializationFields(parameterFields), factoryMethod, parameterNames);
    }

    @Override
    public Object deserialize(Map<String, Object> elements) throws Exception {
        Object[] arguments = new Object[this.parameterNames.size()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = elements.get(this.parameterNames.get(i));
        }
        return this.factoryMethod.method().invoke(null, arguments);
    }

    @Override
    public DeserializationFields fields() {
        return this.fields;
    }

    @Override
    public String description() {
        return SerializedObjectDeserializer.createDescription(this.factoryMethod.describe());
    }

    public ResolvedMethod method() {
        return this.factoryMethod;
    }

    private static void validateDeserializerModifiers(ClassType type, ResolvedMethod deserializationMethod) {
        int deserializationMethodModifiers = deserializationMethod.method().getModifiers();
        if (!Modifier.isStatic(deserializationMethodModifiers)) {
            throw IncompatibleSerializedObjectException.incompatibleSerializedObjectException("The deserialization method %s configured for the SerializedObject of type %s must be static", deserializationMethod, type);
        }
        if (Modifier.isAbstract(deserializationMethodModifiers)) {
            throw IncompatibleSerializedObjectException.incompatibleSerializedObjectException("The deserialization method %s configured for the SerializedObject of type %s must not be abstract", deserializationMethod, type);
        }
        if (!deserializationMethod.returnType().map(type::equals).orElse(false).booleanValue()) {
            throw IncompatibleSerializedObjectException.incompatibleSerializedObjectException("The deserialization method %s configured for the SerializedObject of type %s must return the DTO", deserializationMethod, type);
        }
    }

    public String toString() {
        return "MethodSerializedObjectDeserializer(fields=" + this.fields + ", factoryMethod=" + this.factoryMethod + ", parameterNames=" + this.parameterNames + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSerializedObjectDeserializer)) {
            return false;
        }
        MethodSerializedObjectDeserializer other = (MethodSerializedObjectDeserializer)o;
        DeserializationFields this$fields = this.fields;
        DeserializationFields other$fields = other.fields;
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        ResolvedMethod this$factoryMethod = this.factoryMethod;
        ResolvedMethod other$factoryMethod = other.factoryMethod;
        if (this$factoryMethod == null ? other$factoryMethod != null : !((Object)this$factoryMethod).equals(other$factoryMethod)) {
            return false;
        }
        List<String> this$parameterNames = this.parameterNames;
        List<String> other$parameterNames = other.parameterNames;
        return !(this$parameterNames == null ? other$parameterNames != null : !((Object)this$parameterNames).equals(other$parameterNames));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializationFields $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        ResolvedMethod $factoryMethod = this.factoryMethod;
        result = result * 59 + ($factoryMethod == null ? 43 : ((Object)$factoryMethod).hashCode());
        List<String> $parameterNames = this.parameterNames;
        result = result * 59 + ($parameterNames == null ? 43 : ((Object)$parameterNames).hashCode());
        return result;
    }

    private MethodSerializedObjectDeserializer(DeserializationFields fields, ResolvedMethod factoryMethod, List<String> parameterNames) {
        this.fields = fields;
        this.factoryMethod = factoryMethod;
        this.parameterNames = parameterNames;
    }
}

