/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects;

import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedConstructor;
import de.quantummaid.mapmaid.shared.types.resolver.ResolvedMethod;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;

public final class MultipleMethodsSerializedObjectDeserializer
implements SerializedObjectDeserializer {
    private final DeserializationFields deserializationFields;
    private final ResolvedConstructor constructor;
    private final Map<String, ResolvedMethod> methods;

    public static SerializedObjectDeserializer multipleMethodsSerializedObjectDeserializer(ResolvedConstructor constructor, Map<String, ResolvedMethod> methods) {
        NotNullValidator.validateNotNull(constructor, "constructor");
        NotNullValidator.validateNotNull(methods, "methods");
        Map<String, TypeIdentifier> fieldMap = methods.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> RealTypeIdentifier.realTypeIdentifier(((ResolvedMethod)e.getValue()).parameters().get(0).type())));
        DeserializationFields deserializationFields = DeserializationFields.deserializationFields(fieldMap);
        return new MultipleMethodsSerializedObjectDeserializer(deserializationFields, constructor, methods);
    }

    @Override
    public Object deserialize(Map<String, Object> elements) throws Exception {
        Constructor<?> realConstructor = this.constructor.constructor();
        Object instance = realConstructor.newInstance(new Object[0]);
        for (Map.Entry<String, Object> entry : elements.entrySet()) {
            ResolvedMethod method = this.methods.get(entry.getKey());
            Method realMethod = method.method();
            realMethod.invoke(instance, entry.getValue());
        }
        return instance;
    }

    @Override
    public DeserializationFields fields() {
        return this.deserializationFields;
    }

    @Override
    public String description() {
        String methods = this.methods.values().stream().map(ResolvedMethod::describe).collect(Collectors.joining(", ", "[", "]"));
        return String.format("as serialized object by calling the constructor '%s' and then calling the methods: %s", this.constructor.describe(), methods);
    }

    public String toString() {
        return "MultipleMethodsSerializedObjectDeserializer(deserializationFields=" + this.deserializationFields + ", constructor=" + this.constructor + ", methods=" + this.methods + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleMethodsSerializedObjectDeserializer)) {
            return false;
        }
        MultipleMethodsSerializedObjectDeserializer other = (MultipleMethodsSerializedObjectDeserializer)o;
        DeserializationFields this$deserializationFields = this.deserializationFields;
        DeserializationFields other$deserializationFields = other.deserializationFields;
        if (this$deserializationFields == null ? other$deserializationFields != null : !((Object)this$deserializationFields).equals(other$deserializationFields)) {
            return false;
        }
        ResolvedConstructor this$constructor = this.constructor;
        ResolvedConstructor other$constructor = other.constructor;
        if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
            return false;
        }
        Map<String, ResolvedMethod> this$methods = this.methods;
        Map<String, ResolvedMethod> other$methods = other.methods;
        return !(this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeserializationFields $deserializationFields = this.deserializationFields;
        result = result * 59 + ($deserializationFields == null ? 43 : ((Object)$deserializationFields).hashCode());
        ResolvedConstructor $constructor = this.constructor;
        result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
        Map<String, ResolvedMethod> $methods = this.methods;
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        return result;
    }

    private MultipleMethodsSerializedObjectDeserializer(DeserializationFields deserializationFields, ResolvedConstructor constructor, Map<String, ResolvedMethod> methods) {
        this.deserializationFields = deserializationFields;
        this.constructor = constructor;
        this.methods = methods;
    }
}

