/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.marshalling;

import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.UnsupportedMarshallingTypeException;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Map;
import java.util.Set;

public final class MarshallerRegistry<T> {
    private final Map<MarshallingType, T> map;

    public static <T> MarshallerRegistry<T> marshallerRegistry(Map<MarshallingType, T> map) {
        NotNullValidator.validateNotNull(map, "map");
        return new MarshallerRegistry<T>(map);
    }

    public T getForType(MarshallingType type) {
        NotNullValidator.validateNotNull(type, "type");
        T entry = this.map.get(type);
        if (entry == null) {
            throw UnsupportedMarshallingTypeException.unsupportedMarshallingTypeException(type, this.map.keySet());
        }
        return entry;
    }

    public Set<MarshallingType> supportedTypes() {
        return this.map.keySet();
    }

    public String toString() {
        return "MarshallerRegistry(map=" + this.map + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarshallerRegistry)) {
            return false;
        }
        MarshallerRegistry other = (MarshallerRegistry)o;
        Map<MarshallingType, T> this$map = this.map;
        Map<MarshallingType, T> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<MarshallingType, T> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    private MarshallerRegistry(Map<MarshallingType, T> map) {
        this.map = map;
    }
}

