/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.serialization.SerializationCallback;
import de.quantummaid.mapmaid.mapper.serialization.tracker.SerializationTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class Serializer
implements SerializationCallback {
    private final MarshallerRegistry<Marshaller> marshallers;
    private final Definitions definitions;
    private final CustomPrimitiveMappings customPrimitiveMappings;
    private final DebugInformation debugInformation;

    public static Serializer theSerializer(MarshallerRegistry<Marshaller> marshallers, Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        return new Serializer(marshallers, definitions, customPrimitiveMappings, debugInformation);
    }

    public Set<MarshallingType> supportedMarshallingTypes() {
        return this.marshallers.supportedTypes();
    }

    public String serializeToJson(Object object) {
        return this.serialize(object, MarshallingType.json());
    }

    public String serialize(Object object, MarshallingType marshallingType) {
        return this.serialize(object, marshallingType, input -> input);
    }

    public String serialize(Object object, MarshallingType marshallingType, Function<Map<String, Object>, Map<String, Object>> serializedPropertyInjector) {
        NotNullValidator.validateNotNull(object, "object");
        ResolvedType type = ClassType.typeOfObject(object);
        return this.serialize(object, type, marshallingType, serializedPropertyInjector);
    }

    public String serialize(Object object, ResolvedType type, MarshallingType marshallingType, Function<Map<String, Object>, Map<String, Object>> serializedPropertyInjector) {
        TypeIdentifier typeIdentifier = RealTypeIdentifier.realTypeIdentifier(type);
        return this.serialize(object, typeIdentifier, marshallingType, serializedPropertyInjector);
    }

    public String serialize(Object object, TypeIdentifier type, MarshallingType marshallingType, Function<Map<String, Object>, Map<String, Object>> serializedPropertyInjector) {
        NotNullValidator.validateNotNull(object, "object");
        Map<String, Object> normalized = this.normalize(object, type);
        if (normalized instanceof Map) {
            normalized = serializedPropertyInjector.apply(normalized);
        }
        Marshaller marshaller = this.marshallers.getForType(marshallingType);
        try {
            return marshaller.marshal(normalized);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not marshal normalization %s", normalized), e);
        }
    }

    public String serializeFromMap(Map<String, Object> map, MarshallingType marshallingType) {
        Marshaller marshaller = this.marshallers.getForType(marshallingType);
        try {
            return marshaller.marshal(map);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not marshal from map %s", map), e);
        }
    }

    public String serializeFromUniversalObject(Object object, MarshallingType marshallingType) {
        Marshaller marshaller = this.marshallers.getForType(marshallingType);
        try {
            return marshaller.marshal(object);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not marshal from object %s", object), e);
        }
    }

    public Map<String, Object> serializeToMap(Object object) {
        if (Objects.isNull(object)) {
            return new HashMap<String, Object>(0);
        }
        ResolvedType type = ClassType.typeOfObject(object);
        TypeIdentifier typeIdentifier = RealTypeIdentifier.realTypeIdentifier(type);
        Object normalized = this.normalize(object, typeIdentifier);
        if (!(normalized instanceof Map)) {
            throw new UnsupportedOperationException("Only serialized objects can be serialized to map");
        }
        return (Map)normalized;
    }

    public Object serializeToUniversalObject(Object object) {
        if (Objects.isNull(object)) {
            return new HashMap(0);
        }
        ResolvedType type = ClassType.typeOfObject(object);
        TypeIdentifier typeIdentifier = RealTypeIdentifier.realTypeIdentifier(type);
        Object normalized = this.normalize(object, typeIdentifier);
        return normalized;
    }

    private Object normalize(Object object, TypeIdentifier type) {
        if (Objects.isNull(object)) {
            return null;
        }
        return this.serializeDefinition(type, object, SerializationTracker.serializationTracker()).toNativeJava();
    }

    @Override
    public Universal serializeDefinition(TypeIdentifier type, Object object, SerializationTracker tracker) {
        if (Objects.isNull(object)) {
            return UniversalNull.universalNull();
        }
        SerializationTracker childTracker = tracker.trackToProhibitCyclicReferences(object);
        Definition definition = this.definitions.getDefinitionForType(type);
        return definition.serializer().orElseThrow(() -> {
            ScanInformation scanInformation = this.debugInformation.scanInformationFor(type);
            return MapMaidException.mapMaidException(String.format("No serializer configured for type '%s'", definition.type().description()), scanInformation);
        }).serialize(object, this, childTracker, this.customPrimitiveMappings);
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public String toString() {
        return "Serializer(marshallers=" + this.marshallers + ", definitions=" + this.getDefinitions() + ", customPrimitiveMappings=" + this.customPrimitiveMappings + ", debugInformation=" + this.debugInformation + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Serializer)) {
            return false;
        }
        Serializer other = (Serializer)o;
        MarshallerRegistry<Marshaller> this$marshallers = this.marshallers;
        MarshallerRegistry<Marshaller> other$marshallers = other.marshallers;
        if (this$marshallers == null ? other$marshallers != null : !((Object)this$marshallers).equals(other$marshallers)) {
            return false;
        }
        Definitions this$definitions = this.getDefinitions();
        Definitions other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        CustomPrimitiveMappings this$customPrimitiveMappings = this.customPrimitiveMappings;
        CustomPrimitiveMappings other$customPrimitiveMappings = other.customPrimitiveMappings;
        if (this$customPrimitiveMappings == null ? other$customPrimitiveMappings != null : !((Object)this$customPrimitiveMappings).equals(other$customPrimitiveMappings)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MarshallerRegistry<Marshaller> $marshallers = this.marshallers;
        result = result * 59 + ($marshallers == null ? 43 : ((Object)$marshallers).hashCode());
        Definitions $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        CustomPrimitiveMappings $customPrimitiveMappings = this.customPrimitiveMappings;
        result = result * 59 + ($customPrimitiveMappings == null ? 43 : ((Object)$customPrimitiveMappings).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    private Serializer(MarshallerRegistry<Marshaller> marshallers, Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        this.marshallers = marshallers;
        this.definitions = definitions;
        this.customPrimitiveMappings = customPrimitiveMappings;
        this.debugInformation = debugInformation;
    }
}

