/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject;

import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SerializationFields {
    private final List<SerializationField> fields;

    public static SerializationFields serializationFields(List<SerializationField> fields) {
        NotNullValidator.validateNotNull(fields, "fields");
        return new SerializationFields(fields);
    }

    public static SerializationFields empty() {
        return new SerializationFields(Collections.emptyList());
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public List<SerializationField> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<TypeIdentifier> typesList() {
        return this.fields.stream().map(SerializationField::type).collect(Collectors.toUnmodifiableList());
    }

    public String describe() {
        return this.fields.stream().map(SerializationField::describe).map(s2 -> "\t- " + s2).collect(Collectors.joining("\n"));
    }

    public String toString() {
        return "SerializationFields(fields=" + this.fields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationFields)) {
            return false;
        }
        SerializationFields other = (SerializationFields)o;
        List<SerializationField> this$fields = this.fields;
        List<SerializationField> other$fields = other.fields;
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SerializationField> $fields = this.fields;
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    private SerializationFields(List<SerializationField> fields) {
        this.fields = fields;
    }
}

