/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.shared.types.unresolved.breaking;

import de.quantummaid.mapmaid.shared.types.ClassType;
import de.quantummaid.mapmaid.shared.types.ResolvedType;
import de.quantummaid.mapmaid.shared.types.unresolved.breaking.TypeVariableResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public final class MethodParameterVariableResolver
implements TypeVariableResolver {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final int parameterIndex;

    public static MethodParameterVariableResolver methodParameterVariableResolver(String methodName, Class<?>[] parameterTypes, int parameterIndex) {
        return new MethodParameterVariableResolver(methodName, parameterTypes, parameterIndex);
    }

    @Override
    public ResolvedType resolve(Object object) {
        try {
            Method method = object.getClass().getMethod(this.methodName, this.parameterTypes);
            Parameter parameter = method.getParameters()[this.parameterIndex];
            Class<?> type = parameter.getType();
            return ClassType.fromClassWithoutGenerics(type);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "MethodParameterVariableResolver(methodName=" + this.methodName + ", parameterTypes=" + Arrays.deepToString(this.parameterTypes) + ", parameterIndex=" + this.parameterIndex + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodParameterVariableResolver)) {
            return false;
        }
        MethodParameterVariableResolver other = (MethodParameterVariableResolver)o;
        String this$methodName = this.methodName;
        String other$methodName = other.methodName;
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        return this.parameterIndex == other.parameterIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodName = this.methodName;
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.parameterTypes);
        result = result * 59 + this.parameterIndex;
        return result;
    }

    private MethodParameterVariableResolver(String methodName, Class<?>[] parameterTypes, int parameterIndex) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.parameterIndex = parameterIndex;
    }
}

