/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.quantummaid;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.purejavaendpoint.PureJavaEndpoint;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class QuantumMaid {
    private volatile HttpMaid httpMaid;
    private final List<Consumer<HttpMaid>> endpoints = new ArrayList<Consumer<HttpMaid>>(1);
    private final List<String> endpointUrls = new ArrayList<String>(1);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);

    public static QuantumMaid quantumMaid() {
        return new QuantumMaid();
    }

    public QuantumMaid withHttpMaid(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
        return this;
    }

    public QuantumMaid withLocalHostEndpointOnPort(int port) {
        this.endpoints.add(httpMaid -> PureJavaEndpoint.pureJavaEndpointFor(httpMaid).listeningOnThePort(port));
        this.endpointUrls.add(String.format("http://localhost:%d/", port));
        return this;
    }

    public void runAsynchronously() {
        Thread thread = new Thread(this::run);
        thread.start();
    }

    public void run() {
        this.renderSplash();
        try (HttpMaid httpMaid = this.httpMaid;){
            this.endpoints.forEach(endpoint -> endpoint.accept(httpMaid));
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
        this.countDownLatch.countDown();
    }

    private void renderSplash() {
        System.out.println("   ____                    _                   __  __       _     _ \n  / __ \\                  | |                 |  \\/  |     (_)   | |\n | |  | |_   _  __ _ _ __ | |_ _   _ _ __ ___ | \\  / | __ _ _  __| |\n | |  | | | | |/ _` | '_ \\| __| | | | '_ ` _ \\| |\\/| |/ _` | |/ _` |\n | |__| | |_| | (_| | | | | |_| |_| | | | | | | |  | | (_| | | (_| |\n  \\___\\_\\\\__,_|\\__,_|_| |_|\\__|\\__,_|_| |_| |_|_|  |_|\\__,_|_|\\__,_|\n");
        Duration startUpTime = this.httpMaid.getMetaDatum(HttpMaid.STARTUP_TIME);
        long milliseconds = TimeUnit.MILLISECONDS.convert(startUpTime);
        System.out.println(String.format("Startup took: %sms", milliseconds));
        this.endpointUrls.forEach(url -> System.out.println(String.format("Serving %s", url)));
        System.out.println();
    }
}

