/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel.internal.filtering;

import de.quantummaid.eventmaid.channel.internal.filtering.FilterApplier;
import de.quantummaid.eventmaid.channel.internal.filtering.PostFilterActions;
import de.quantummaid.eventmaid.filtering.Filter;
import de.quantummaid.eventmaid.filtering.FilterActions;
import java.util.List;

public final class FilterApplierImpl<T>
implements FilterApplier<T> {
    @Override
    public void applyAll(T message, List<Filter<T>> filters, PostFilterActions<T> postFilterActions) {
        if (filters.isEmpty()) {
            postFilterActions.onAllPassed(message);
            return;
        }
        CurrentFilterActions filterActions = new CurrentFilterActions(filters, postFilterActions);
        Filter<T> firstFilter = filters.get(0);
        firstFilter.apply(message, filterActions);
        if (filterActions.messageWasForgotten()) {
            postFilterActions.onForgotten(message);
        }
    }

    private final class CurrentFilterActions
    implements FilterActions<T> {
        private final List<Filter<T>> filters;
        private final PostFilterActions<T> postFilterActions;
        private int currentFilterIndex;
        private boolean messageNotForgotten;

        @Override
        public void block(T message) {
            this.messageNotForgotten = true;
            this.postFilterActions.onBlock(message);
        }

        @Override
        public void pass(T message) {
            if (++this.currentFilterIndex < this.filters.size()) {
                Filter nextFilter = this.filters.get(this.currentFilterIndex);
                nextFilter.apply(message, this);
            } else {
                this.messageNotForgotten = true;
                this.postFilterActions.onAllPassed(message);
            }
        }

        public boolean messageWasForgotten() {
            return !this.messageNotForgotten;
        }

        private CurrentFilterActions(List<Filter<T>> filters, PostFilterActions<T> postFilterActions) {
            this.filters = filters;
            this.postFilterActions = postFilterActions;
        }
    }
}

