/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.pipe.transport;

import de.quantummaid.eventmaid.internal.exceptions.BubbleUpWrappedException;
import de.quantummaid.eventmaid.internal.pipe.error.PipeErrorHandler;
import de.quantummaid.eventmaid.internal.pipe.events.PipeEventListener;
import de.quantummaid.eventmaid.internal.pipe.excepions.NoSuitableSubscriberException;
import de.quantummaid.eventmaid.subscribing.AcceptingBehavior;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import java.util.List;

public final class SynchronousDelivery<T> {
    private final PipeEventListener<T> eventListener;
    private final PipeErrorHandler<T> pipeErrorHandler;

    public void deliver(T message, List<Subscriber<T>> subscribers) {
        if (subscribers.isEmpty()) {
            this.handleNoSubscriberException(message);
        } else {
            for (Subscriber<T> subscriber : subscribers) {
                boolean continueDelivery = this.deliveryMessageTo(message, subscriber);
                if (continueDelivery) continue;
                return;
            }
            this.eventListener.messageDeliverySucceeded(message);
        }
    }

    private void handleNoSubscriberException(T message) {
        NoSuitableSubscriberException exception = new NoSuitableSubscriberException();
        if (this.pipeErrorHandler.shouldErrorBeHandledAndDeliveryAborted(message, exception)) {
            this.eventListener.messageDeliveryFailed(message, exception);
            this.pipeErrorHandler.handleException(message, exception);
        } else {
            this.eventListener.messageDeliverySucceeded(message);
        }
    }

    private boolean deliveryMessageTo(T message, Subscriber<T> subscriber) {
        try {
            AcceptingBehavior acceptingBehavior = subscriber.accept(message);
            boolean proceedWithDelivery = acceptingBehavior.continueDelivery();
            if (!proceedWithDelivery) {
                this.eventListener.messageDeliverySucceeded(message);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof BubbleUpWrappedException) {
                throw e;
            }
            try {
                if (this.pipeErrorHandler.shouldErrorBeHandledAndDeliveryAborted(message, e)) {
                    this.eventListener.messageDeliveryFailed(message, e);
                    this.pipeErrorHandler.handleException(message, e);
                    return false;
                }
                return true;
            }
            catch (BubbleUpWrappedException bubbledException) {
                throw bubbledException;
            }
            catch (Exception rethrownException) {
                throw new BubbleUpWrappedException(rethrownException);
            }
        }
    }

    SynchronousDelivery(PipeEventListener<T> eventListener, PipeErrorHandler<T> pipeErrorHandler) {
        this.eventListener = eventListener;
        this.pipeErrorHandler = pipeErrorHandler;
    }
}

