/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events;

import de.quantummaid.httpmaid.events.enriching.EnrichableMap;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Event {
    private final EnrichableMap map;
    private final List<Object> typeInjections;

    public static Event event(EnrichableMap map) {
        return new Event(map, new ArrayList<Object>());
    }

    public void enrich(String key, Object value) {
        this.map.enrichEitherTopOrSecondLevel(key, value);
    }

    public void addTypeInjection(Object injection) {
        Validators.validateNotNull(injection, "injection");
        this.typeInjections.add(injection);
    }

    public Map<String, Object> asMap() {
        return this.map.asMap();
    }

    public List<Object> typeInjections() {
        return Collections.unmodifiableList(this.typeInjections);
    }

    public String toString() {
        return "Event(map=" + this.map + ", typeInjections=" + this.typeInjections + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        EnrichableMap this$map = this.map;
        EnrichableMap other$map = other.map;
        if (this$map == null ? other$map != null : !((Object)this$map).equals(other$map)) {
            return false;
        }
        List<Object> this$typeInjections = this.typeInjections;
        List<Object> other$typeInjections = other.typeInjections;
        return !(this$typeInjections == null ? other$typeInjections != null : !((Object)this$typeInjections).equals(other$typeInjections));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnrichableMap $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        List<Object> $typeInjections = this.typeInjections;
        result = result * 59 + ($typeInjections == null ? 43 : ((Object)$typeInjections).hashCode());
        return result;
    }

    private Event(EnrichableMap map, List<Object> typeInjections) {
        this.map = map;
        this.typeInjections = typeInjections;
    }
}

