/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.enriching;

import de.quantummaid.httpmaid.events.Event;
import de.quantummaid.httpmaid.events.enriching.enrichers.CookieEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.Enricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.HeaderEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.PathParameterEnricher;
import de.quantummaid.httpmaid.events.enriching.enrichers.QueryParameterEnricher;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;

public final class PerEventEnrichers {
    private final List<PathParameterEnricher> pathParameterEnrichers = new ArrayList<PathParameterEnricher>();
    private final List<PathParameterEnricher> removedPathParameterEnrichers = new ArrayList<PathParameterEnricher>();
    private final List<QueryParameterEnricher> queryParameterEnrichers = new ArrayList<QueryParameterEnricher>();
    private final List<HeaderEnricher> headerEnrichers = new ArrayList<HeaderEnricher>();
    private final List<CookieEnricher> cookieEnrichers = new ArrayList<CookieEnricher>();
    private final List<Enricher> authenticationInformationEnrichers = new ArrayList<Enricher>();

    public static PerEventEnrichers perEventEnrichers() {
        return new PerEventEnrichers();
    }

    public void addPathParameterEnricher(PathParameterEnricher enricher) {
        this.pathParameterEnrichers.add(enricher);
    }

    public void removePathParameterEnricher(PathParameterEnricher enricher) {
        this.removedPathParameterEnrichers.add(enricher);
    }

    public void addQueryParameterEnricher(QueryParameterEnricher enricher) {
        this.queryParameterEnrichers.add(enricher);
    }

    public void addHeaderEnricher(HeaderEnricher enricher) {
        this.headerEnrichers.add(enricher);
    }

    public void addCookieEnricher(CookieEnricher enricher) {
        this.cookieEnrichers.add(enricher);
    }

    public void addAuthenticationInformationEnricher(Enricher enricher) {
        this.authenticationInformationEnrichers.add(enricher);
    }

    public void enrich(HttpRequest httpRequest, Event event) {
        this.pathParameterEnrichers.removeAll(this.removedPathParameterEnrichers);
        this.pathParameterEnrichers.forEach(enricher -> enricher.enrich(httpRequest, event));
        this.queryParameterEnrichers.forEach(enricher -> enricher.enrich(httpRequest, event));
        this.headerEnrichers.forEach(enricher -> enricher.enrich(httpRequest, event));
        this.cookieEnrichers.forEach(enricher -> enricher.enrich(httpRequest, event));
        this.authenticationInformationEnrichers.forEach(enricher -> enricher.enrich(httpRequest, event));
    }

    public String toString() {
        return "PerEventEnrichers(pathParameterEnrichers=" + this.pathParameterEnrichers + ", removedPathParameterEnrichers=" + this.removedPathParameterEnrichers + ", queryParameterEnrichers=" + this.queryParameterEnrichers + ", headerEnrichers=" + this.headerEnrichers + ", cookieEnrichers=" + this.cookieEnrichers + ", authenticationInformationEnrichers=" + this.authenticationInformationEnrichers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerEventEnrichers)) {
            return false;
        }
        PerEventEnrichers other = (PerEventEnrichers)o;
        List<PathParameterEnricher> this$pathParameterEnrichers = this.pathParameterEnrichers;
        List<PathParameterEnricher> other$pathParameterEnrichers = other.pathParameterEnrichers;
        if (this$pathParameterEnrichers == null ? other$pathParameterEnrichers != null : !((Object)this$pathParameterEnrichers).equals(other$pathParameterEnrichers)) {
            return false;
        }
        List<PathParameterEnricher> this$removedPathParameterEnrichers = this.removedPathParameterEnrichers;
        List<PathParameterEnricher> other$removedPathParameterEnrichers = other.removedPathParameterEnrichers;
        if (this$removedPathParameterEnrichers == null ? other$removedPathParameterEnrichers != null : !((Object)this$removedPathParameterEnrichers).equals(other$removedPathParameterEnrichers)) {
            return false;
        }
        List<QueryParameterEnricher> this$queryParameterEnrichers = this.queryParameterEnrichers;
        List<QueryParameterEnricher> other$queryParameterEnrichers = other.queryParameterEnrichers;
        if (this$queryParameterEnrichers == null ? other$queryParameterEnrichers != null : !((Object)this$queryParameterEnrichers).equals(other$queryParameterEnrichers)) {
            return false;
        }
        List<HeaderEnricher> this$headerEnrichers = this.headerEnrichers;
        List<HeaderEnricher> other$headerEnrichers = other.headerEnrichers;
        if (this$headerEnrichers == null ? other$headerEnrichers != null : !((Object)this$headerEnrichers).equals(other$headerEnrichers)) {
            return false;
        }
        List<CookieEnricher> this$cookieEnrichers = this.cookieEnrichers;
        List<CookieEnricher> other$cookieEnrichers = other.cookieEnrichers;
        if (this$cookieEnrichers == null ? other$cookieEnrichers != null : !((Object)this$cookieEnrichers).equals(other$cookieEnrichers)) {
            return false;
        }
        List<Enricher> this$authenticationInformationEnrichers = this.authenticationInformationEnrichers;
        List<Enricher> other$authenticationInformationEnrichers = other.authenticationInformationEnrichers;
        return !(this$authenticationInformationEnrichers == null ? other$authenticationInformationEnrichers != null : !((Object)this$authenticationInformationEnrichers).equals(other$authenticationInformationEnrichers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PathParameterEnricher> $pathParameterEnrichers = this.pathParameterEnrichers;
        result = result * 59 + ($pathParameterEnrichers == null ? 43 : ((Object)$pathParameterEnrichers).hashCode());
        List<PathParameterEnricher> $removedPathParameterEnrichers = this.removedPathParameterEnrichers;
        result = result * 59 + ($removedPathParameterEnrichers == null ? 43 : ((Object)$removedPathParameterEnrichers).hashCode());
        List<QueryParameterEnricher> $queryParameterEnrichers = this.queryParameterEnrichers;
        result = result * 59 + ($queryParameterEnrichers == null ? 43 : ((Object)$queryParameterEnrichers).hashCode());
        List<HeaderEnricher> $headerEnrichers = this.headerEnrichers;
        result = result * 59 + ($headerEnrichers == null ? 43 : ((Object)$headerEnrichers).hashCode());
        List<CookieEnricher> $cookieEnrichers = this.cookieEnrichers;
        result = result * 59 + ($cookieEnrichers == null ? 43 : ((Object)$cookieEnrichers).hashCode());
        List<Enricher> $authenticationInformationEnrichers = this.authenticationInformationEnrichers;
        result = result * 59 + ($authenticationInformationEnrichers == null ? 43 : ((Object)$authenticationInformationEnrichers).hashCode());
        return result;
    }

    private PerEventEnrichers() {
    }
}

