/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.processors;

import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.messageFunction.MessageFunction;
import de.quantummaid.eventmaid.messageFunction.MessageFunctionBuilder;
import de.quantummaid.eventmaid.messageFunction.ResponseFuture;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.events.Event;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.events.processors.EventDispatchingException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public final class DispatchEventProcessor
implements Processor {
    private final MessageFunction messageFunction;

    public static Processor dispatchEventProcessor(MessageBus messageBus) {
        MessageFunction messageFunction = MessageFunctionBuilder.aMessageFunction(messageBus);
        return new DispatchEventProcessor(messageFunction);
    }

    @Override
    public void apply(MetaData metaData) {
        EventType eventType = metaData.get(EventModule.EVENT_TYPE);
        Event event = metaData.get(EventModule.EVENT);
        ResponseFuture request = this.messageFunction.request(eventType, event);
        try {
            ProcessingContext<Object> raw = request.getRaw();
            if (raw.getErrorPayload() != null) {
                Map errorPayload = (Map)raw.getErrorPayload();
                Throwable exception = (Throwable)errorPayload.get("Exception");
                throw EventDispatchingException.eventDispatchingException(exception);
            }
            Object response = raw.getPayload();
            metaData.set(EventModule.RECEIVED_EVENT, Optional.ofNullable(response));
        }
        catch (InterruptedException e) {
            request.cancel(true);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw EventDispatchingException.eventDispatchingException(e.getCause());
        }
    }

    public String toString() {
        return "DispatchEventProcessor(messageFunction=" + this.messageFunction + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DispatchEventProcessor)) {
            return false;
        }
        DispatchEventProcessor other = (DispatchEventProcessor)o;
        MessageFunction this$messageFunction = this.messageFunction;
        MessageFunction other$messageFunction = other.messageFunction;
        return !(this$messageFunction == null ? other$messageFunction != null : !this$messageFunction.equals(other$messageFunction));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageFunction $messageFunction = this.messageFunction;
        result = result * 59 + ($messageFunction == null ? 43 : $messageFunction.hashCode());
        return result;
    }

    private DispatchEventProcessor(MessageFunction messageFunction) {
        this.messageFunction = messageFunction;
    }
}

