/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path.statemachine;

import java.util.List;

public final class ElementPosition<T> {
    private final int index;
    private final List<T> elements;

    public static <T> ElementPosition<T> start(List<T> elements) {
        return new ElementPosition<T>(0, elements);
    }

    public boolean isEnd() {
        return this.elements.size() <= this.index;
    }

    public ElementPosition<T> next() {
        return new ElementPosition<T>(this.index + 1, this.elements);
    }

    public T get() {
        if (this.isEnd()) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements.get(this.index);
    }

    public String toString() {
        return "ElementPosition(index=" + this.index + ", elements=" + this.elements + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementPosition)) {
            return false;
        }
        ElementPosition other = (ElementPosition)o;
        if (this.index != other.index) {
            return false;
        }
        List<T> this$elements = this.elements;
        List<T> other$elements = other.elements;
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index;
        List<T> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    private ElementPosition(int index, List<T> elements) {
        this.index = index;
        this.elements = elements;
    }
}

