/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.SecurityModule;
import de.quantummaid.httpmaid.security.SecurityProcessor;
import de.quantummaid.httpmaid.security.config.SecurityConfigurator;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;

public final class SimpleSecurityConfigurator
implements SecurityConfigurator<SimpleSecurityConfigurator> {
    private final Processor processor;
    private volatile ChainName phase;
    private final List<Filter> filters = new LinkedList<Filter>();

    public static SimpleSecurityConfigurator simpleSecurityConfigurator(Processor processor) {
        Validators.validateNotNull(processor, "processor");
        SimpleSecurityConfigurator simpleSecurityConfigurator = new SimpleSecurityConfigurator(processor);
        simpleSecurityConfigurator.beforeBodyProcessing();
        return simpleSecurityConfigurator;
    }

    @Override
    public SimpleSecurityConfigurator inPhase(ChainName phase) {
        Validators.validateNotNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    @Override
    public SimpleSecurityConfigurator onlyRequestsThat(Filter filter) {
        Validators.validateNotNull(filter, "filter");
        this.filters.add(filter);
        return this;
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        SecurityModule securityModule = dependencyRegistry.getDependency(SecurityModule.class);
        securityModule.addSecurityProcessor(SecurityProcessor.securityProcessor(this.processor, this.phase, this.filters));
    }

    public String toString() {
        return "SimpleSecurityConfigurator(processor=" + this.processor + ", phase=" + this.phase + ", filters=" + this.filters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleSecurityConfigurator)) {
            return false;
        }
        SimpleSecurityConfigurator other = (SimpleSecurityConfigurator)o;
        Processor this$processor = this.processor;
        Processor other$processor = other.processor;
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        ChainName this$phase = this.phase;
        ChainName other$phase = other.phase;
        if (this$phase == null ? other$phase != null : !((Object)this$phase).equals(other$phase)) {
            return false;
        }
        List<Filter> this$filters = this.filters;
        List<Filter> other$filters = other.filters;
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Processor $processor = this.processor;
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        ChainName $phase = this.phase;
        result = result * 59 + ($phase == null ? 43 : ((Object)$phase).hashCode());
        List<Filter> $filters = this.filters;
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    private SimpleSecurityConfigurator(Processor processor) {
        this.processor = processor;
    }
}

