/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases;

import de.quantummaid.eventmaid.internal.collections.filtermap.FilterMapBuilder;
import de.quantummaid.eventmaid.internal.collections.predicatemap.PredicateMapBuilder;
import de.quantummaid.eventmaid.mapping.Demapifier;
import de.quantummaid.eventmaid.mapping.ExceptionMapifier;
import de.quantummaid.eventmaid.mapping.Mapifier;
import de.quantummaid.eventmaid.messageBus.MessageBus;
import de.quantummaid.eventmaid.processingContext.EventType;
import de.quantummaid.eventmaid.serializedMessageBus.SerializedMessageBus;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.LowLevelUseCaseAdapterBuilder;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.UseCaseAdapter;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.events.Event;
import de.quantummaid.httpmaid.events.EventFactory;
import de.quantummaid.httpmaid.events.EventModule;
import de.quantummaid.httpmaid.generator.GenerationCondition;
import de.quantummaid.httpmaid.handler.distribution.DistributableHandler;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributors;
import de.quantummaid.httpmaid.startupchecks.StartupChecks;
import de.quantummaid.httpmaid.usecases.eventfactories.MultipleParametersEventFactory;
import de.quantummaid.httpmaid.usecases.eventfactories.SingleParameterEventFactory;
import de.quantummaid.httpmaid.usecases.instantiation.UseCaseInstantiator;
import de.quantummaid.httpmaid.usecases.instantiation.UseCaseInstantiatorFactory;
import de.quantummaid.httpmaid.usecases.instantiation.ZeroArgumentsConstructorUseCaseInstantiator;
import de.quantummaid.httpmaid.usecases.method.UseCaseMethod;
import de.quantummaid.httpmaid.usecases.serializing.SerializationAndDeserializationProvider;
import de.quantummaid.httpmaid.usecases.serializing.UseCaseSerializationAndDeserialization;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class UseCasesModule
implements ChainModule {
    public static final MetaDataKey<SerializedMessageBus> SERIALIZED_MESSAGE_BUS = MetaDataKey.metaDataKey("SERIALIZED_MESSAGE_BUS");
    private SerializationAndDeserializationProvider serializationAndDeserializationProvider;
    private UseCaseInstantiatorFactory useCaseInstantiatorFactory = types -> ZeroArgumentsConstructorUseCaseInstantiator.zeroArgumentsConstructorUseCaseInstantiator();
    private final Map<ResolvedType, EventType> useCaseToEventMappings = new HashMap<ResolvedType, EventType>();
    private final List<UseCaseMethod> useCaseMethods = new ArrayList<UseCaseMethod>();

    public static UseCasesModule useCasesModule() {
        return new UseCasesModule();
    }

    public void setUseCaseInstantiatorFactory(UseCaseInstantiatorFactory useCaseInstantiatorFactory) {
        this.useCaseInstantiatorFactory = useCaseInstantiatorFactory;
    }

    public void addUseCaseToEventMapping(ResolvedType useCaseClass, EventType eventType) {
        Validators.validateNotNull(useCaseClass, "useCaseClass");
        Validators.validateNotNull(eventType, "eventType");
        this.useCaseToEventMappings.put(useCaseClass, eventType);
    }

    public void setSerializationAndDeserializationProvider(SerializationAndDeserializationProvider serializationAndDeserializationProvider) {
        this.serializationAndDeserializationProvider = serializationAndDeserializationProvider;
    }

    @Override
    public List<ChainModule> supplyModulesIfNotAlreadyPresent() {
        return Collections.singletonList(EventModule.eventModule());
    }

    @Override
    public void init(MetaData configurationMetaData) {
        HandlerDistributors handlerDistributors = configurationMetaData.get(HandlerDistributors.HANDLER_DISTRIBUTORS);
        handlerDistributors.register(handler -> handler.handler() instanceof GenericType, handler -> {
            GenericType useCaseClass = (GenericType)handler.handler();
            return this.registerUseCase(useCaseClass, handler.condition(), handler.perRouteConfigurators());
        });
        handlerDistributors.register(handler -> handler.handler() instanceof Class, handler -> {
            Class clazz = (Class)handler.handler();
            GenericType useCaseClass = GenericType.genericType(clazz);
            return this.registerUseCase(useCaseClass, handler.condition(), handler.perRouteConfigurators());
        });
    }

    private List<DistributableHandler> registerUseCase(GenericType<?> genericType, GenerationCondition condition, List<PerRouteConfigurator> perRouteConfigurators) {
        ResolvedType resolvedType = genericType.toResolvedType();
        EventType eventType = EventType.eventTypeFromString(resolvedType.description());
        this.useCaseToEventMappings.put(resolvedType, eventType);
        this.useCaseMethods.add(UseCaseMethod.useCaseMethodOf(resolvedType));
        DistributableHandler eventHandler = DistributableHandler.distributableHandler(condition, eventType, perRouteConfigurators);
        return Collections.singletonList(eventHandler);
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        EventModule eventModule = dependencyRegistry.getDependency(EventModule.class);
        this.useCaseMethods.forEach(useCaseMethod -> {
            ResolvedType useCaseClass = useCaseMethod.useCaseClass();
            EventType eventType = this.useCaseToEventMappings.get(useCaseClass);
            EventFactory eventFactory = UseCasesModule.buildEventFactory(useCaseMethod);
            eventModule.setEventFactoryFor(eventType, eventFactory);
        });
    }

    @Override
    public void register(ChainExtender extender) {
        LowLevelUseCaseAdapterBuilder adapterBuilder = UseCasesModule.createAdapterBuilder();
        UseCaseSerializationAndDeserialization serializationAndDeserialization = this.serializationAndDeserializationProvider.provide(this.useCaseMethods);
        List<Class<?>> useCaseClasses = this.useCaseMethods.stream().map(UseCaseMethod::useCaseClass).map(ResolvedType::assignableType).collect(Collectors.toList());
        UseCaseInstantiator useCaseInstantiator = this.useCaseInstantiatorFactory.createInstantiator(useCaseClasses);
        StartupChecks startupChecks = extender.getMetaDatum(StartupChecks.STARTUP_CHECKS);
        this.useCaseMethods.forEach(useCaseMethod -> {
            ResolvedType useCaseClass = useCaseMethod.useCaseClass();
            EventType eventType = this.useCaseToEventMappings.get(useCaseClass);
            adapterBuilder.addUseCase(useCaseClass.assignableType(), eventType, (useCase, untypedEvent, callingContext) -> {
                Event event = (Event)untypedEvent;
                Map<String, Object> parameters = serializationAndDeserialization.deserializeParameters(event, useCaseClass);
                Optional<Object> returnValue = useCaseMethod.invoke(useCase, parameters, event);
                return returnValue.map(object -> serializationAndDeserialization.serializeReturnValue(object, useCaseMethod.returnType().orElseThrow())).orElse(null);
            });
            startupChecks.addStartupCheck(() -> useCaseInstantiator.check(GenericType.fromResolvedType(useCaseClass)));
        });
        adapterBuilder.setUseCaseInstantiator(useCaseInstantiator::instantiate);
        PredicateMapBuilder<Exception, Mapifier<Exception>> exceptionSerializers = PredicateMapBuilder.predicateMapBuilder();
        exceptionSerializers.setDefaultValue(ExceptionMapifier.defaultExceptionMapifier());
        adapterBuilder.setExceptionSerializers(exceptionSerializers);
        UseCaseAdapter useCaseAdapter = adapterBuilder.build();
        MessageBus messageBus = extender.getMetaDatum(EventModule.MESSAGE_BUS);
        SerializedMessageBus serializedMessageBus = useCaseAdapter.attachAndEnhance(messageBus);
        extender.addMetaDatum(SERIALIZED_MESSAGE_BUS, serializedMessageBus);
    }

    private static LowLevelUseCaseAdapterBuilder createAdapterBuilder() {
        LowLevelUseCaseAdapterBuilder adapterBuilder = LowLevelUseCaseAdapterBuilder.aLowLevelUseCaseInvocationBuilder();
        adapterBuilder.setRequestSerializers(UseCasesModule.failingPredicateMap());
        adapterBuilder.setRequestDeserializers(UseCasesModule.failingFilterMap());
        adapterBuilder.setReseponseSerializers(UseCasesModule.failingPredicateMap());
        adapterBuilder.setResponseDeserializers(UseCasesModule.failingFilterMap());
        return adapterBuilder;
    }

    private static FilterMapBuilder<Class<?>, Object, Demapifier<?>> failingFilterMap() {
        FilterMapBuilder<Class<?>, Object, Demapifier<?>> filterMap = FilterMapBuilder.filterMapBuilder();
        filterMap.setDefaultValue((targetType, map) -> {
            throw new UnsupportedOperationException();
        });
        return filterMap;
    }

    private static PredicateMapBuilder<Object, Mapifier<Object>> failingPredicateMap() {
        PredicateMapBuilder<Object, Mapifier<Object>> predicateMap = PredicateMapBuilder.predicateMapBuilder();
        predicateMap.setDefaultValue(object -> {
            throw new UnsupportedOperationException();
        });
        return predicateMap;
    }

    private static EventFactory buildEventFactory(UseCaseMethod useCaseMethod) {
        if (useCaseMethod.isSingleParameterUseCase()) {
            String name = useCaseMethod.singleParameterName();
            return SingleParameterEventFactory.singleParameterEventFactory(name);
        }
        List<String> parameterNames = useCaseMethod.parameterNames();
        return MultipleParametersEventFactory.multipleParametersEventFactory(parameterNames);
    }

    public String toString() {
        return "UseCasesModule(serializationAndDeserializationProvider=" + this.serializationAndDeserializationProvider + ", useCaseInstantiatorFactory=" + this.useCaseInstantiatorFactory + ", useCaseToEventMappings=" + this.useCaseToEventMappings + ", useCaseMethods=" + this.useCaseMethods + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCasesModule)) {
            return false;
        }
        UseCasesModule other = (UseCasesModule)o;
        SerializationAndDeserializationProvider this$serializationAndDeserializationProvider = this.serializationAndDeserializationProvider;
        SerializationAndDeserializationProvider other$serializationAndDeserializationProvider = other.serializationAndDeserializationProvider;
        if (this$serializationAndDeserializationProvider == null ? other$serializationAndDeserializationProvider != null : !this$serializationAndDeserializationProvider.equals(other$serializationAndDeserializationProvider)) {
            return false;
        }
        UseCaseInstantiatorFactory this$useCaseInstantiatorFactory = this.useCaseInstantiatorFactory;
        UseCaseInstantiatorFactory other$useCaseInstantiatorFactory = other.useCaseInstantiatorFactory;
        if (this$useCaseInstantiatorFactory == null ? other$useCaseInstantiatorFactory != null : !this$useCaseInstantiatorFactory.equals(other$useCaseInstantiatorFactory)) {
            return false;
        }
        Map<ResolvedType, EventType> this$useCaseToEventMappings = this.useCaseToEventMappings;
        Map<ResolvedType, EventType> other$useCaseToEventMappings = other.useCaseToEventMappings;
        if (this$useCaseToEventMappings == null ? other$useCaseToEventMappings != null : !((Object)this$useCaseToEventMappings).equals(other$useCaseToEventMappings)) {
            return false;
        }
        List<UseCaseMethod> this$useCaseMethods = this.useCaseMethods;
        List<UseCaseMethod> other$useCaseMethods = other.useCaseMethods;
        return !(this$useCaseMethods == null ? other$useCaseMethods != null : !((Object)this$useCaseMethods).equals(other$useCaseMethods));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SerializationAndDeserializationProvider $serializationAndDeserializationProvider = this.serializationAndDeserializationProvider;
        result = result * 59 + ($serializationAndDeserializationProvider == null ? 43 : $serializationAndDeserializationProvider.hashCode());
        UseCaseInstantiatorFactory $useCaseInstantiatorFactory = this.useCaseInstantiatorFactory;
        result = result * 59 + ($useCaseInstantiatorFactory == null ? 43 : $useCaseInstantiatorFactory.hashCode());
        Map<ResolvedType, EventType> $useCaseToEventMappings = this.useCaseToEventMappings;
        result = result * 59 + ($useCaseToEventMappings == null ? 43 : ((Object)$useCaseToEventMappings).hashCode());
        List<UseCaseMethod> $useCaseMethods = this.useCaseMethods;
        result = result * 59 + ($useCaseMethods == null ? 43 : ((Object)$useCaseMethods).hashCode());
        return result;
    }

    private UseCasesModule() {
    }
}

