/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.AdvancedBuilder;
import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.conventional.ConventionalDefinitionFactories;
import de.quantummaid.mapmaid.builder.conventional.ConventionalDetectors;
import de.quantummaid.mapmaid.builder.customtypes.CustomType;
import de.quantummaid.mapmaid.builder.customtypes.DeserializationOnlyType;
import de.quantummaid.mapmaid.builder.customtypes.DuplexType;
import de.quantummaid.mapmaid.builder.customtypes.SerializationOnlyType;
import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.injection.FixedInjectionDeserializer;
import de.quantummaid.mapmaid.builder.injection.FixedInjector;
import de.quantummaid.mapmaid.builder.injection.InjectionDeserializer;
import de.quantummaid.mapmaid.builder.injection.InjectionSerializer;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.Reason;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.processing.Processor;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.fixed.unreasoned.FixedUnreasoned;
import de.quantummaid.mapmaid.builder.resolving.states.injecting.InjectedDefinition;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.deserialization.Deserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.AggregatedValidationException;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingList;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingWithPropertyPath;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationError;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationErrorsMapping;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationMappings;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.serialization.Serializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public final class MapMaidBuilder {
    private final SimpleDetector detector = ConventionalDetectors.conventionalDetector();
    private final Processor processor = Processor.processor();
    private final AdvancedBuilder advancedBuilder = AdvancedBuilder.advancedBuilder();
    private final List<Recipe> recipes = Collection.smallList();
    private final ValidationMappings validationMappings = ValidationMappings.empty();
    private final ValidationErrorsMapping validationErrorsMapping = validationErrors -> {
        throw AggregatedValidationException.fromList(validationErrors);
    };

    public static MapMaidBuilder mapMaidBuilder() {
        return new MapMaidBuilder();
    }

    public MapMaidBuilder serializing(Class<?> type) {
        return this.serializing(GenericType.genericType(type));
    }

    public MapMaidBuilder serializing(GenericType<?> genericType) {
        return this.withType(genericType, RequiredCapabilities.serialization());
    }

    public <T> MapMaidBuilder serializing(SerializationOnlyType<T> customType) {
        return this.withCustomType(RequiredCapabilities.serialization(), customType);
    }

    public MapMaidBuilder deserializing(Class<?> type) {
        return this.deserializing(GenericType.genericType(type));
    }

    public MapMaidBuilder deserializing(GenericType<?> genericType) {
        return this.withType(genericType, RequiredCapabilities.deserialization());
    }

    public <T> MapMaidBuilder deserializing(DeserializationOnlyType<T> customType) {
        return this.withCustomType(RequiredCapabilities.deserialization(), customType);
    }

    public MapMaidBuilder serializingAndDeserializing(Class<?> type) {
        return this.serializingAndDeserializing(GenericType.genericType(type));
    }

    public MapMaidBuilder serializingAndDeserializing(GenericType<?> genericType) {
        return this.withType(genericType, RequiredCapabilities.duplex());
    }

    public <T> MapMaidBuilder serializingAndDeserializing(DuplexType<T> customType) {
        return this.withCustomType(RequiredCapabilities.duplex(), customType);
    }

    public MapMaidBuilder injecting(Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.injecting(genericType);
    }

    public MapMaidBuilder injecting(GenericType<?> genericType) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(genericType);
        return this.injecting(typeIdentifier);
    }

    public MapMaidBuilder injecting(TypeIdentifier typeIdentifier) {
        InjectionDeserializer deserializer = InjectionDeserializer.injectionDeserializer(typeIdentifier);
        return this.injecting(typeIdentifier, deserializer);
    }

    public <T> MapMaidBuilder injecting(Class<T> type, FixedInjector<T> injector) {
        GenericType<T> genericType = GenericType.genericType(type);
        return this.injecting(genericType, injector);
    }

    public <T> MapMaidBuilder injecting(GenericType<T> genericType, FixedInjector<T> injector) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(genericType);
        return this.injecting(typeIdentifier, injector);
    }

    public MapMaidBuilder injecting(TypeIdentifier typeIdentifier, FixedInjector<?> injector) {
        FixedInjectionDeserializer deserializer = FixedInjectionDeserializer.diDeserializer(injector);
        return this.injecting(typeIdentifier, deserializer);
    }

    private MapMaidBuilder injecting(TypeIdentifier typeIdentifier, TypeDeserializer deserializer) {
        Context context = Context.emptyContext(this.processor::dispatch, typeIdentifier);
        InjectionSerializer serializer = InjectionSerializer.injectionSerializer(typeIdentifier);
        context.setSerializer(serializer);
        context.setDeserializer(deserializer);
        StatefulDefinition statefulDefinition = InjectedDefinition.injectedDefinition(context);
        this.processor.addState(statefulDefinition);
        this.processor.dispatch(Signal.addSerialization(typeIdentifier, Reason.manuallyAdded()));
        this.processor.dispatch(Signal.addDeserialization(typeIdentifier, Reason.manuallyAdded()));
        return this;
    }

    public MapMaidBuilder withManuallyAddedTypes(Class<?> ... type) {
        NotNullValidator.validateNotNull(type, "type");
        Arrays.stream(type).forEach(this::serializingAndDeserializing);
        return this;
    }

    public MapMaidBuilder withType(Class<?> type, RequiredCapabilities capabilities) {
        return this.withType(GenericType.genericType(type), capabilities);
    }

    public MapMaidBuilder withType(GenericType<?> type, RequiredCapabilities capabilities) {
        return this.withType(type, capabilities, Reason.manuallyAdded());
    }

    public MapMaidBuilder withType(Class<?> type, RequiredCapabilities capabilities, String reason) {
        return this.withType(type, capabilities, Reason.reason(reason));
    }

    public MapMaidBuilder withType(Class<?> type, RequiredCapabilities capabilities, Reason reason) {
        return this.withType(GenericType.genericType(type), capabilities, reason);
    }

    public MapMaidBuilder withType(GenericType<?> type, RequiredCapabilities capabilities, String reason) {
        return this.withType(type, capabilities, Reason.reason(reason));
    }

    public MapMaidBuilder withType(GenericType<?> type, RequiredCapabilities capabilities, Reason reason) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(capabilities, "capabilities");
        NotNullValidator.validateNotNull(reason, "reason");
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
        if (capabilities.hasSerialization()) {
            this.processor.dispatch(Signal.addSerialization(typeIdentifier, reason));
        }
        if (capabilities.hasDeserialization()) {
            this.processor.dispatch(Signal.addDeserialization(typeIdentifier, reason));
        }
        return this;
    }

    public <T> MapMaidBuilder withCustomType(RequiredCapabilities capabilities, CustomType<T> customType) {
        NotNullValidator.validateNotNull(capabilities, "capabilities");
        NotNullValidator.validateNotNull(customType, "customType");
        TypeIdentifier typeIdentifier = customType.type();
        Optional<TypeSerializer> serializer = customType.serializer();
        if (capabilities.hasSerialization() && serializer.isEmpty()) {
            throw new IllegalArgumentException(String.format("serializer is missing for type '%s'", typeIdentifier.description()));
        }
        Optional<TypeDeserializer> deserializer = customType.deserializer();
        if (capabilities.hasDeserialization() && deserializer.isEmpty()) {
            throw new IllegalArgumentException(String.format("deserializer is missing for type '%s'", typeIdentifier.description()));
        }
        Context context = Context.emptyContext(this.processor::dispatch, typeIdentifier);
        serializer.ifPresent(context::setSerializer);
        deserializer.ifPresent(context::setDeserializer);
        StatefulDefinition statefulDefinition = FixedUnreasoned.fixedUnreasoned(context);
        this.processor.addState(statefulDefinition);
        if (capabilities.hasSerialization()) {
            this.processor.dispatch(Signal.addSerialization(typeIdentifier, Reason.manuallyAdded()));
        }
        if (capabilities.hasDeserialization()) {
            this.processor.dispatch(Signal.addDeserialization(typeIdentifier, Reason.manuallyAdded()));
        }
        return this;
    }

    public MapMaidBuilder usingRecipe(Recipe recipe) {
        this.recipes.add(recipe);
        return this;
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingValidationError(Class<T> exceptionIndicatingValidationError) {
        return this.withExceptionIndicatingValidationError(exceptionIndicatingValidationError, (exception, propertyPath) -> new ValidationError(exception.getMessage(), propertyPath));
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingValidationError(Class<T> exceptionIndicatingValidationError, ExceptionMappingWithPropertyPath<T> exceptionMapping) {
        this.validationMappings.putOneToOne(exceptionIndicatingValidationError, exceptionMapping);
        return this;
    }

    public <T extends Throwable> MapMaidBuilder withExceptionIndicatingMultipleValidationErrors(Class<T> exceptionType, ExceptionMappingList<T> mapping) {
        NotNullValidator.validateNotNull(exceptionType, "exceptionType");
        NotNullValidator.validateNotNull(mapping, "mapping");
        this.validationMappings.putOneToMany(exceptionType, mapping);
        return this;
    }

    public MapMaidBuilder withAdvancedSettings(Consumer<AdvancedBuilder> configurator) {
        configurator.accept(this.advancedBuilder);
        return this;
    }

    public MapMaid build() {
        this.recipes.forEach(Recipe::init);
        this.recipes.forEach(recipe -> recipe.cook(this));
        Disambiguators disambiguators = this.advancedBuilder.buildDisambiguators();
        Map<TypeIdentifier, CollectionResult> result = this.processor.collect(this.detector, disambiguators);
        HashMap<TypeIdentifier, Definition> definitionsMap = new HashMap<TypeIdentifier, Definition>(result.size());
        HashMap<TypeIdentifier, ScanInformation> scanInformationMap = new HashMap<TypeIdentifier, ScanInformation>(result.size());
        result.forEach((type, collectionResult) -> {
            definitionsMap.put((TypeIdentifier)type, collectionResult.definition());
            scanInformationMap.put((TypeIdentifier)type, collectionResult.scanInformation());
        });
        DebugInformation debugInformation = DebugInformation.debugInformation(scanInformationMap);
        Definitions definitions = Definitions.definitions(definitionsMap, debugInformation);
        MarshallerRegistry<Marshaller> marshallerRegistry = this.advancedBuilder.buildMarshallerRegistry();
        Serializer serializer = Serializer.theSerializer(marshallerRegistry, definitions, ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS, debugInformation);
        MarshallerRegistry<Unmarshaller> unmarshallerRegistry = this.advancedBuilder.buildUnmarshallerRegistry();
        Deserializer deserializer = Deserializer.theDeserializer(unmarshallerRegistry, definitions, ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS, this.validationMappings, this.validationErrorsMapping, debugInformation);
        return MapMaid.mapMaid(serializer, deserializer, debugInformation);
    }

    public String toString() {
        return "MapMaidBuilder(detector=" + this.detector + ", processor=" + this.processor + ", advancedBuilder=" + this.advancedBuilder + ", recipes=" + this.recipes + ", validationMappings=" + this.validationMappings + ", validationErrorsMapping=" + this.validationErrorsMapping + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidBuilder)) {
            return false;
        }
        MapMaidBuilder other = (MapMaidBuilder)o;
        SimpleDetector this$detector = this.detector;
        SimpleDetector other$detector = other.detector;
        if (this$detector == null ? other$detector != null : !((Object)this$detector).equals(other$detector)) {
            return false;
        }
        Processor this$processor = this.processor;
        Processor other$processor = other.processor;
        if (this$processor == null ? other$processor != null : !((Object)this$processor).equals(other$processor)) {
            return false;
        }
        AdvancedBuilder this$advancedBuilder = this.advancedBuilder;
        AdvancedBuilder other$advancedBuilder = other.advancedBuilder;
        if (this$advancedBuilder == null ? other$advancedBuilder != null : !((Object)this$advancedBuilder).equals(other$advancedBuilder)) {
            return false;
        }
        List<Recipe> this$recipes = this.recipes;
        List<Recipe> other$recipes = other.recipes;
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        ValidationMappings this$validationMappings = this.validationMappings;
        ValidationMappings other$validationMappings = other.validationMappings;
        if (this$validationMappings == null ? other$validationMappings != null : !((Object)this$validationMappings).equals(other$validationMappings)) {
            return false;
        }
        ValidationErrorsMapping this$validationErrorsMapping = this.validationErrorsMapping;
        ValidationErrorsMapping other$validationErrorsMapping = other.validationErrorsMapping;
        return !(this$validationErrorsMapping == null ? other$validationErrorsMapping != null : !this$validationErrorsMapping.equals(other$validationErrorsMapping));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SimpleDetector $detector = this.detector;
        result = result * 59 + ($detector == null ? 43 : ((Object)$detector).hashCode());
        Processor $processor = this.processor;
        result = result * 59 + ($processor == null ? 43 : ((Object)$processor).hashCode());
        AdvancedBuilder $advancedBuilder = this.advancedBuilder;
        result = result * 59 + ($advancedBuilder == null ? 43 : ((Object)$advancedBuilder).hashCode());
        List<Recipe> $recipes = this.recipes;
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        ValidationMappings $validationMappings = this.validationMappings;
        result = result * 59 + ($validationMappings == null ? 43 : ((Object)$validationMappings).hashCode());
        ValidationErrorsMapping $validationErrorsMapping = this.validationErrorsMapping;
        result = result * 59 + ($validationErrorsMapping == null ? 43 : $validationErrorsMapping.hashCode());
        return result;
    }

    private MapMaidBuilder() {
    }
}

