/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.mapper.definitions.Definition;

public final class RequiredCapabilities {
    private boolean serialization;
    private boolean deserialization;

    public static RequiredCapabilities none() {
        return new RequiredCapabilities(false, false);
    }

    public static RequiredCapabilities duplex() {
        return new RequiredCapabilities(true, true);
    }

    public static RequiredCapabilities serialization() {
        return new RequiredCapabilities(true, false);
    }

    public static RequiredCapabilities deserialization() {
        return new RequiredCapabilities(false, true);
    }

    public static RequiredCapabilities fromDefinition(Definition definition) {
        boolean serialization = definition.serializer().isPresent();
        boolean deserialization = definition.deserializer().isPresent();
        return new RequiredCapabilities(serialization, deserialization);
    }

    public void add(RequiredCapabilities other) {
        this.serialization = this.serialization || other.serialization;
        this.deserialization = this.deserialization || other.deserialization;
    }

    public boolean contains(RequiredCapabilities other) {
        if (other.serialization && !this.serialization) {
            return false;
        }
        return !other.deserialization || this.deserialization;
    }

    public boolean hasDeserialization() {
        return this.deserialization;
    }

    public boolean hasSerialization() {
        return this.serialization;
    }

    public String toString() {
        return "RequiredCapabilities(serialization=" + this.serialization + ", deserialization=" + this.deserialization + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequiredCapabilities)) {
            return false;
        }
        RequiredCapabilities other = (RequiredCapabilities)o;
        if (this.serialization != other.serialization) {
            return false;
        }
        return this.deserialization == other.deserialization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serialization ? 79 : 97);
        result = result * 59 + (this.deserialization ? 79 : 97);
        return result;
    }

    private RequiredCapabilities(boolean serialization, boolean deserialization) {
        this.serialization = serialization;
        this.deserialization = deserialization;
    }
}

