/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject.fields;

import de.quantummaid.mapmaid.builder.detection.serializedobject.fields.FieldDetector;
import de.quantummaid.mapmaid.builder.detection.serializedobject.fields.GetterFieldQuery;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.SerializationFieldQuery;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public final class GetterFieldDetector
implements FieldDetector {
    public static FieldDetector getterFieldDetector() {
        return new GetterFieldDetector();
    }

    @Override
    public List<SerializationField> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        return ((ClassType)type).methods().stream().filter(resolvedMethod -> resolvedMethod.method().getName().startsWith("get")).filter(resolvedMethod -> !Modifier.isStatic(resolvedMethod.method().getModifiers())).filter(resolvedMethod -> resolvedMethod.method().getReturnType() != Void.TYPE).filter(resolvedMethod -> resolvedMethod.parameters().isEmpty()).map(resolvedMethod -> {
            ResolvedType resolvedType = resolvedMethod.returnType().orElseThrow();
            Method method = resolvedMethod.method();
            String name = GetterFieldDetector.extractGetterFieldName(method.getName());
            SerializationFieldQuery query = GetterFieldQuery.getterFieldQuery(method);
            return SerializationField.serializationField(resolvedType, name, query);
        }).collect(Collectors.toList());
    }

    private static String extractGetterFieldName(String methodName) {
        String withoutGet = methodName.substring(3);
        String firstCharacter = String.valueOf(withoutGet.charAt(0));
        String lowercaseFirstCharacter = firstCharacter.toLowerCase(Locale.US);
        return lowercaseFirstCharacter + withoutGet.substring(1);
    }

    public String toString() {
        return "GetterFieldDetector()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof GetterFieldDetector;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private GetterFieldDetector() {
    }
}

