/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.marshallers.urlencoded;

import de.quantummaid.mapmaid.builder.recipes.marshallers.urlencoded.Key;
import de.quantummaid.mapmaid.builder.recipes.marshallers.urlencoded.KeyValue;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class UrlEncodedMarshaller
implements Marshaller {
    public static Marshaller urlEncodedMarshaller() {
        return new UrlEncodedMarshaller();
    }

    @Override
    public String marshal(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        ArrayList<KeyValue> parts = new ArrayList<KeyValue>(10);
        this.marshal(Key.emptyKey(), parts, object);
        return parts.stream().map(KeyValue::render).collect(Collectors.joining("&"));
    }

    private void marshal(Key keyPrefix, List<KeyValue> parts, Object object) {
        if (object instanceof Map) {
            this.marshalMap(keyPrefix, parts, (Map)object);
        } else if (object instanceof List) {
            this.marshalList(keyPrefix, parts, (List)object);
        } else if (object.getClass().isArray()) {
            List<Object> list = Arrays.asList((Object[])object);
            this.marshalList(keyPrefix, parts, list);
        } else if (object instanceof String) {
            this.marshalString(keyPrefix, parts, (String)object);
        } else {
            throw new IllegalArgumentException(String.format("Unable to marshal for url-encoded because the type of '%s' is not supported", object));
        }
    }

    private void marshalMap(Key keyPrefix, List<KeyValue> parts, Map<String, Object> map) {
        map.keySet().forEach(key -> {
            Key childKey = keyPrefix.child((String)key);
            this.marshal(childKey, parts, map.get(key));
        });
    }

    private void marshalList(Key keyPrefix, List<KeyValue> parts, List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            Key childKey = keyPrefix.child(String.valueOf(i));
            Object object = list.get(i);
            this.marshal(childKey, parts, object);
        }
    }

    private void marshalString(Key key, List<KeyValue> parts, String string) {
        parts.add(KeyValue.keyValue(key, string));
    }

    public String toString() {
        return "UrlEncodedMarshaller()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof UrlEncodedMarshaller;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private UrlEncodedMarshaller() {
    }
}

