/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving;

import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class Reason {
    private final String reason;
    private final TypeIdentifier parent;

    public static Reason reason(String reason) {
        NotNullValidator.validateNotNull(reason, "reason");
        return new Reason(reason, null);
    }

    public static Reason manuallyAdded() {
        return Reason.reason("manually added");
    }

    public static Reason becauseOf(TypeIdentifier parent) {
        return new Reason(String.format("because of %s", parent.description()), parent);
    }

    public String render() {
        return this.reason;
    }

    public String toString() {
        return "Reason(reason=" + this.reason + ", parent=" + this.parent + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reason)) {
            return false;
        }
        Reason other = (Reason)o;
        String this$reason = this.reason;
        String other$reason = other.reason;
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        TypeIdentifier this$parent = this.parent;
        TypeIdentifier other$parent = other.parent;
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reason = this.reason;
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        TypeIdentifier $parent = this.parent;
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    private Reason(String reason, TypeIdentifier parent) {
        this.reason = reason;
        this.parent = parent;
    }
}

