/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.factories.primitives;

import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class PrimitiveInformation {
    final Class<?> type;
    final Function<String, Object> deserializer;
    final String description;

    public static Map<ResolvedType, PrimitiveInformation> primitiveInformations() {
        return Stream.of(PrimitiveInformation.primitiveInformation(String.class, Function.identity(), "is already a String"), PrimitiveInformation.primitiveInformation(Integer.TYPE, Integer::parseInt, "Integer::parseInt"), PrimitiveInformation.primitiveInformation(Integer.class, Integer::valueOf, "Integer::valueOf"), PrimitiveInformation.primitiveInformation(Long.TYPE, Long::parseLong, "Long::parseLong"), PrimitiveInformation.primitiveInformation(Long.class, Long::valueOf, "Long::valueOf"), PrimitiveInformation.primitiveInformation(Short.TYPE, Short::parseShort, "Short::parseShort"), PrimitiveInformation.primitiveInformation(Short.class, Short::valueOf, "Short::valueOf"), PrimitiveInformation.primitiveInformation(Double.TYPE, Double::parseDouble, "Double::parseDouble"), PrimitiveInformation.primitiveInformation(Double.class, Double::valueOf, "Double::valueOf"), PrimitiveInformation.primitiveInformation(Float.TYPE, Float::parseFloat, "Float::parseFloat"), PrimitiveInformation.primitiveInformation(Float.class, Float::valueOf, "Float::valueOf"), PrimitiveInformation.primitiveInformation(Boolean.TYPE, Boolean::parseBoolean, "Boolean::parseBoolean"), PrimitiveInformation.primitiveInformation(Boolean.class, Boolean::valueOf, "Boolean::valueOf")).collect(Collectors.toMap(primitiveInformation -> ClassType.fromClassWithoutGenerics(primitiveInformation.type), primitiveInformation -> primitiveInformation));
    }

    public static <T> PrimitiveInformation primitiveInformation(Class<T> type, Function<String, T> deserializer, String description) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(deserializer, "deserializer");
        NotNullValidator.validateNotNull(description, "description");
        return new PrimitiveInformation(type, deserializer, description);
    }

    public String toString() {
        return "PrimitiveInformation(type=" + this.type + ", deserializer=" + this.deserializer + ", description=" + this.description + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveInformation)) {
            return false;
        }
        PrimitiveInformation other = (PrimitiveInformation)o;
        Class<?> this$type = this.type;
        Class<?> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Function<String, Object> this$deserializer = this.deserializer;
        Function<String, Object> other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Function<String, Object> $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private PrimitiveInformation(Class<?> type, Function<String, Object> deserializer, String description) {
        this.type = type;
        this.deserializer = deserializer;
        this.description = description;
    }
}

