/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class JacksonMarshaller
implements Marshaller {
    private final ObjectMapper objectMapper;

    public static Marshaller jacksonMarshaller(ObjectMapper objectMapper) {
        NotNullValidator.validateNotNull(objectMapper, "objectMapper");
        return new JacksonMarshaller(objectMapper);
    }

    @Override
    public String marshal(Object object) throws Exception {
        return this.objectMapper.writeValueAsString(object);
    }

    public String toString() {
        return "JacksonMarshaller(objectMapper=" + this.objectMapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonMarshaller)) {
            return false;
        }
        JacksonMarshaller other = (JacksonMarshaller)o;
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    private JacksonMarshaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

