/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.deserialization.InternalDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.Unmarshallers;
import de.quantummaid.mapmaid.mapper.deserialization.UnmarshallingException;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationErrorsMapping;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationMappings;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.injector.InjectorFactory;
import de.quantummaid.mapmaid.mapper.injector.InjectorLambda;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Set;

public final class Deserializer {
    private final Definitions definitions;
    private final ValidationMappings validationMappings;
    private final Unmarshallers unmarshallers;
    private final InternalDeserializer internalDeserializer;
    private final DebugInformation debugInformation;
    private final InjectorFactory injectorFactory = InjectorFactory.emptyInjectorFactory();

    public static Deserializer theDeserializer(MarshallerRegistry<Unmarshaller> unmarshallerRegistry, Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, ValidationMappings exceptionMapping, ValidationErrorsMapping onValidationErrors, DebugInformation debugInformation) {
        NotNullValidator.validateNotNull(unmarshallerRegistry, "unmarshallerRegistry");
        NotNullValidator.validateNotNull(definitions, "definitions");
        NotNullValidator.validateNotNull(customPrimitiveMappings, "customPrimitiveMappings");
        NotNullValidator.validateNotNull(exceptionMapping, "validationMappings");
        NotNullValidator.validateNotNull(onValidationErrors, "onValidationErrors");
        NotNullValidator.validateNotNull(debugInformation, "debugInformation");
        Unmarshallers unmarshallers = Unmarshallers.unmarshallers(unmarshallerRegistry);
        InternalDeserializer internalDeserializer = InternalDeserializer.internalDeserializer(definitions, customPrimitiveMappings, onValidationErrors);
        return new Deserializer(definitions, exceptionMapping, unmarshallers, internalDeserializer, debugInformation);
    }

    public <T> T deserializeFromUniversalObject(Object input, Class<T> targetType) {
        return this.deserializeFromUniversalObject(input, targetType, InjectorLambda.noop());
    }

    public <T> T deserializeFromUniversalObject(Object input, ResolvedType targetType) {
        TypeIdentifier typeIdentifier = RealTypeIdentifier.realTypeIdentifier(targetType);
        return this.deserializeFromUniversalObject(input, typeIdentifier);
    }

    public <T> T deserializeFromUniversalObject(Object input, TypeIdentifier targetType) {
        return this.deserializeFromUniversalObject(input, targetType, InjectorLambda.noop());
    }

    public <T> T deserializeFromUniversalObject(Object input, Class<T> targetType, InjectorLambda injectorProducer) {
        return this.deserializeFromUniversalObject(input, ClassType.fromClassWithoutGenerics(targetType), injectorProducer);
    }

    public <T> T deserializeFromUniversalObject(Object input, ResolvedType targetType, InjectorLambda injectorProducer) {
        TypeIdentifier typeIdentifier = RealTypeIdentifier.realTypeIdentifier(targetType);
        return this.deserializeFromUniversalObject(input, typeIdentifier, injectorProducer);
    }

    public <T> T deserializeFromUniversalObject(Object input, TypeIdentifier targetType, InjectorLambda injectorProducer) {
        Universal universal = Universal.fromNativeJava(input);
        return this.deserialize(universal, targetType, injectorProducer);
    }

    public Object deserializeToUniversalObject(String input, MarshallingType type) {
        Universal universal = this.unmarshallers.unmarshall(input, type);
        return universal.toNativeJava();
    }

    public Object deserialize(String input, TypeIdentifier targetType, MarshallingType marshallingType, InjectorLambda injectorProducer) {
        try {
            Universal unmarshalled = this.unmarshallers.unmarshall(input, marshallingType);
            return this.deserialize(unmarshalled, targetType, injectorProducer);
        }
        catch (UnmarshallingException e) {
            ScanInformation scanInformation = this.debugInformation.scanInformationFor(targetType);
            throw MapMaidException.mapMaidException(String.format("Error during unmarshalling for type '%s' with input '%s'", targetType.description(), input), e, scanInformation);
        }
    }

    private <T> T deserialize(Universal input, TypeIdentifier targetType, InjectorLambda injectorProducer) {
        NotNullValidator.validateNotNull(input, "input");
        NotNullValidator.validateNotNull(targetType, "targetType");
        NotNullValidator.validateNotNull(injectorProducer, "jsonInjector");
        ExceptionTracker exceptionTracker = ExceptionTracker.emptyTracker(input, this.validationMappings);
        Injector injector = this.injectorFactory.create();
        injectorProducer.setupInjector(injector);
        return this.internalDeserializer.deserialize(input, targetType, exceptionTracker, injector, this.debugInformation);
    }

    public Set<MarshallingType> supportedMarshallingTypes() {
        return this.unmarshallers.supportedMarshallingTypes();
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public String toString() {
        return "Deserializer(definitions=" + this.getDefinitions() + ", validationMappings=" + this.validationMappings + ", unmarshallers=" + this.unmarshallers + ", internalDeserializer=" + this.internalDeserializer + ", debugInformation=" + this.debugInformation + ", injectorFactory=" + this.injectorFactory + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deserializer)) {
            return false;
        }
        Deserializer other = (Deserializer)o;
        Definitions this$definitions = this.getDefinitions();
        Definitions other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        ValidationMappings this$validationMappings = this.validationMappings;
        ValidationMappings other$validationMappings = other.validationMappings;
        if (this$validationMappings == null ? other$validationMappings != null : !((Object)this$validationMappings).equals(other$validationMappings)) {
            return false;
        }
        Unmarshallers this$unmarshallers = this.unmarshallers;
        Unmarshallers other$unmarshallers = other.unmarshallers;
        if (this$unmarshallers == null ? other$unmarshallers != null : !((Object)this$unmarshallers).equals(other$unmarshallers)) {
            return false;
        }
        InternalDeserializer this$internalDeserializer = this.internalDeserializer;
        InternalDeserializer other$internalDeserializer = other.internalDeserializer;
        if (this$internalDeserializer == null ? other$internalDeserializer != null : !((Object)this$internalDeserializer).equals(other$internalDeserializer)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        if (this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation)) {
            return false;
        }
        InjectorFactory this$injectorFactory = this.injectorFactory;
        InjectorFactory other$injectorFactory = other.injectorFactory;
        return !(this$injectorFactory == null ? other$injectorFactory != null : !((Object)this$injectorFactory).equals(other$injectorFactory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Definitions $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        ValidationMappings $validationMappings = this.validationMappings;
        result = result * 59 + ($validationMappings == null ? 43 : ((Object)$validationMappings).hashCode());
        Unmarshallers $unmarshallers = this.unmarshallers;
        result = result * 59 + ($unmarshallers == null ? 43 : ((Object)$unmarshallers).hashCode());
        InternalDeserializer $internalDeserializer = this.internalDeserializer;
        result = result * 59 + ($internalDeserializer == null ? 43 : ((Object)$internalDeserializer).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        InjectorFactory $injectorFactory = this.injectorFactory;
        result = result * 59 + ($injectorFactory == null ? 43 : ((Object)$injectorFactory).hashCode());
        return result;
    }

    private Deserializer(Definitions definitions, ValidationMappings validationMappings, Unmarshallers unmarshallers, InternalDeserializer internalDeserializer, DebugInformation debugInformation) {
        this.definitions = definitions;
        this.validationMappings = validationMappings;
        this.unmarshallers = unmarshallers;
        this.internalDeserializer = internalDeserializer;
        this.debugInformation = debugInformation;
    }
}

