/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.quantummaid;

import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.purejavaendpoint.PureJavaEndpoint;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class QuantumMaid {
    private volatile HttpMaid httpMaid;
    private final List<Consumer<HttpMaid>> endpoints = new ArrayList<Consumer<HttpMaid>>(1);
    private final List<String> endpointUrls = new ArrayList<String>(1);
    private final CountDownLatch termination = new CountDownLatch(1);
    private final Thread shutdownHook = new Thread(this::close);

    public static QuantumMaid quantumMaid() {
        return new QuantumMaid();
    }

    public QuantumMaid withHttpMaid(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
        return this;
    }

    public QuantumMaid withLocalHostEndpointOnPort(int port) {
        this.endpoints.add(httpMaid -> PureJavaEndpoint.pureJavaEndpointFor(httpMaid).listeningOnThePort(port));
        this.endpointUrls.add(String.format("http://localhost:%d/", port));
        return this;
    }

    public void runAsynchronously() {
        CountDownLatch initialization = new CountDownLatch(1);
        Thread thread = new Thread(() -> this.run(initialization));
        thread.start();
        try {
            initialization.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void run() {
        this.run(new CountDownLatch(1));
    }

    private void run(CountDownLatch initialization) {
        try (HttpMaid httpMaid = this.httpMaid;){
            Instant begin = Instant.now();
            this.endpoints.forEach(endpoint -> endpoint.accept(httpMaid));
            Instant end = Instant.now();
            Duration endpointStartUpTime = Duration.between(begin, end);
            this.renderSplash(endpointStartUpTime);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            initialization.countDown();
            try {
                this.termination.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() {
        this.termination.countDown();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    private void renderSplash(Duration endpointStartupTime) {
        System.out.println("   ____                    _                   __  __       _     _ \n  / __ \\                  | |                 |  \\/  |     (_)   | |\n | |  | |_   _  __ _ _ __ | |_ _   _ _ __ ___ | \\  / | __ _ _  __| |\n | |  | | | | |/ _` | '_ \\| __| | | | '_ ` _ \\| |\\/| |/ _` | |/ _` |\n | |__| | |_| | (_| | | | | |_| |_| | | | | | | |  | | (_| | | (_| |\n  \\___\\_\\\\__,_|\\__,_|_| |_|\\__|\\__,_|_| |_| |_|_|  |_|\\__,_|_|\\__,_|\n");
        Duration httpMaidStartUpTime = this.httpMaid.getMetaDatum(HttpMaid.STARTUP_TIME);
        long httpMaidMilliseconds = TimeUnit.MILLISECONDS.convert(httpMaidStartUpTime);
        long endpointsMilliseconds = TimeUnit.MILLISECONDS.convert(endpointStartupTime);
        long combinedMilliseconds = httpMaidMilliseconds + endpointsMilliseconds;
        System.out.println(String.format("Startup took: %sms (%sms initialization, %sms endpoint startup)", combinedMilliseconds, httpMaidMilliseconds, endpointsMilliseconds));
        this.endpointUrls.forEach(url -> System.out.println(String.format("Serving %s", url)));
        System.out.println();
    }

    public String toString() {
        return "QuantumMaid(httpMaid=" + this.httpMaid + ", endpoints=" + this.endpoints + ", endpointUrls=" + this.endpointUrls + ", termination=" + this.termination + ", shutdownHook=" + this.shutdownHook + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuantumMaid)) {
            return false;
        }
        QuantumMaid other = (QuantumMaid)o;
        HttpMaid this$httpMaid = this.httpMaid;
        HttpMaid other$httpMaid = other.httpMaid;
        if (this$httpMaid == null ? other$httpMaid != null : !this$httpMaid.equals(other$httpMaid)) {
            return false;
        }
        List<Consumer<HttpMaid>> this$endpoints = this.endpoints;
        List<Consumer<HttpMaid>> other$endpoints = other.endpoints;
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        List<String> this$endpointUrls = this.endpointUrls;
        List<String> other$endpointUrls = other.endpointUrls;
        if (this$endpointUrls == null ? other$endpointUrls != null : !((Object)this$endpointUrls).equals(other$endpointUrls)) {
            return false;
        }
        CountDownLatch this$termination = this.termination;
        CountDownLatch other$termination = other.termination;
        if (this$termination == null ? other$termination != null : !this$termination.equals(other$termination)) {
            return false;
        }
        Thread this$shutdownHook = this.shutdownHook;
        Thread other$shutdownHook = other.shutdownHook;
        return !(this$shutdownHook == null ? other$shutdownHook != null : !this$shutdownHook.equals(other$shutdownHook));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMaid $httpMaid = this.httpMaid;
        result = result * 59 + ($httpMaid == null ? 43 : $httpMaid.hashCode());
        List<Consumer<HttpMaid>> $endpoints = this.endpoints;
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        List<String> $endpointUrls = this.endpointUrls;
        result = result * 59 + ($endpointUrls == null ? 43 : ((Object)$endpointUrls).hashCode());
        CountDownLatch $termination = this.termination;
        result = result * 59 + ($termination == null ? 43 : $termination.hashCode());
        Thread $shutdownHook = this.shutdownHook;
        result = result * 59 + ($shutdownHook == null ? 43 : $shutdownHook.hashCode());
        return result;
    }

    private QuantumMaid() {
    }
}

