/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid.unresolved.breaking;

import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.unresolved.breaking.FieldTypeVariableResolver;
import de.quantummaid.reflectmaid.unresolved.breaking.MethodParameterVariableResolver;
import de.quantummaid.reflectmaid.unresolved.breaking.TypeVariableResolver;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class TypeVariableResolvers {
    private final List<String> relevantTypeVariables;
    private final Map<String, Optional<TypeVariableResolver>> typeVariableResolvers;

    public static TypeVariableResolvers resolversFor(Class<?> type) {
        TypeVariable<Class<?>>[] typeParameters = type.getTypeParameters();
        List<String> names = Arrays.stream(typeParameters).map(TypeVariable::getName).collect(Collectors.toList());
        HashMap<String, Optional<TypeVariableResolver>> resolvers = new HashMap<String, Optional<TypeVariableResolver>>(typeParameters.length);
        Arrays.stream(typeParameters).forEach(typeVariable -> {
            String name = typeVariable.getName();
            Optional<TypeVariableResolver> typeVariableResolver = TypeVariableResolvers.resolverForVariable(typeVariable, type);
            resolvers.put(name, typeVariableResolver);
        });
        return TypeVariableResolvers.resolvers(names, resolvers);
    }

    private static Optional<TypeVariableResolver> resolverForVariable(TypeVariable<?> typeVariable, Class<?> type) {
        Optional<TypeVariableResolver> fieldResolver = Arrays.stream(type.getFields()).filter(field -> typeVariable.equals(field.getGenericType())).map(FieldTypeVariableResolver::fieldTypeVariableResolver).findFirst();
        return fieldResolver;
    }

    private static Optional<TypeVariableResolver> resolverForMethod(TypeVariable<?> typeVariable, Method method) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.getParameterizedType().equals(typeVariable)) continue;
            return Optional.of(MethodParameterVariableResolver.methodParameterVariableResolver(method.getName(), method.getParameterTypes(), i));
        }
        return Optional.empty();
    }

    private static TypeVariableResolvers resolvers(List<String> relevantTypeVariables, Map<String, Optional<TypeVariableResolver>> resolverMap) {
        NotNullValidator.validateNotNull(relevantTypeVariables, "relevantTypeVariables");
        NotNullValidator.validateNotNull(resolverMap, "resolverMap");
        return new TypeVariableResolvers(relevantTypeVariables, resolverMap);
    }

    public List<ResolvedType> resolve(Object object) {
        return this.relevantTypeVariables.stream().map(this.typeVariableResolvers::get).map(resolver -> (TypeVariableResolver)resolver.orElseThrow(() -> new UnsupportedOperationException(String.format("Unable to resolve type variables based on object '%s'", object)))).map(resolver -> resolver.resolve(object)).collect(Collectors.toList());
    }

    public String toString() {
        return "TypeVariableResolvers(relevantTypeVariables=" + this.relevantTypeVariables + ", typeVariableResolvers=" + this.typeVariableResolvers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeVariableResolvers)) {
            return false;
        }
        TypeVariableResolvers other = (TypeVariableResolvers)o;
        List<String> this$relevantTypeVariables = this.relevantTypeVariables;
        List<String> other$relevantTypeVariables = other.relevantTypeVariables;
        if (this$relevantTypeVariables == null ? other$relevantTypeVariables != null : !((Object)this$relevantTypeVariables).equals(other$relevantTypeVariables)) {
            return false;
        }
        Map<String, Optional<TypeVariableResolver>> this$typeVariableResolvers = this.typeVariableResolvers;
        Map<String, Optional<TypeVariableResolver>> other$typeVariableResolvers = other.typeVariableResolvers;
        return !(this$typeVariableResolvers == null ? other$typeVariableResolvers != null : !((Object)this$typeVariableResolvers).equals(other$typeVariableResolvers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $relevantTypeVariables = this.relevantTypeVariables;
        result = result * 59 + ($relevantTypeVariables == null ? 43 : ((Object)$relevantTypeVariables).hashCode());
        Map<String, Optional<TypeVariableResolver>> $typeVariableResolvers = this.typeVariableResolvers;
        result = result * 59 + ($typeVariableResolvers == null ? 43 : ((Object)$typeVariableResolvers).hashCode());
        return result;
    }

    private TypeVariableResolvers(List<String> relevantTypeVariables, Map<String, Optional<TypeVariableResolver>> typeVariableResolvers) {
        this.relevantTypeVariables = relevantTypeVariables;
        this.typeVariableResolvers = typeVariableResolvers;
    }
}

