/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.identification;

import de.quantummaid.eventmaid.internal.enforcing.InvalidInputException;
import de.quantummaid.eventmaid.internal.enforcing.StringValidator;
import java.util.UUID;

public final class MessageId {
    private final UUID value;

    public static MessageId fromString(String value) {
        String cleaned = StringValidator.cleaned(value);
        try {
            return new MessageId(UUID.fromString(cleaned));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInputException("Must be a valid uuid.");
        }
    }

    public static MessageId newUniqueMessageId() {
        UUID uuid = UUID.randomUUID();
        return new MessageId(uuid);
    }

    public String stringValue() {
        return this.value.toString();
    }

    public String toString() {
        return "MessageId(value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageId)) {
            return false;
        }
        MessageId other = (MessageId)o;
        UUID this$value = this.value;
        UUID other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    private MessageId(UUID value) {
        this.value = value;
    }
}

