/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.pipe;

import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.internal.pipe.Pipe;
import de.quantummaid.eventmaid.internal.pipe.PipeImpl;
import de.quantummaid.eventmaid.internal.pipe.PipeType;
import de.quantummaid.eventmaid.internal.pipe.error.ErrorThrowingPipeErrorHandler;
import de.quantummaid.eventmaid.internal.pipe.error.PipeErrorHandler;
import de.quantummaid.eventmaid.internal.pipe.events.PipeEventListener;
import de.quantummaid.eventmaid.internal.pipe.events.SimplePipeEventListener;
import de.quantummaid.eventmaid.internal.pipe.statistics.AtomicPipeStatisticsCollector;
import de.quantummaid.eventmaid.internal.pipe.statistics.PipeStatisticsCollector;
import de.quantummaid.eventmaid.internal.pipe.transport.TransportMechanism;
import de.quantummaid.eventmaid.internal.pipe.transport.TransportMechanismFactory;
import java.util.concurrent.CopyOnWriteArrayList;

public final class PipeBuilder<T> {
    private PipeType pipeType = PipeType.SYNCHRONOUS;
    private PipeStatisticsCollector statisticsCollector = AtomicPipeStatisticsCollector.atomicPipeStatisticsCollector();
    private PipeErrorHandler<T> errorHandler = new ErrorThrowingPipeErrorHandler();
    private PipeEventListener<T> eventListener;
    private AsynchronousConfiguration asynchronousConfiguration;

    public static <T> PipeBuilder<T> aPipe() {
        return new PipeBuilder<T>();
    }

    public static <T> PipeBuilder<T> aPipeForClass(Class<T> tClass) {
        return new PipeBuilder<T>();
    }

    public PipeBuilder<T> ofType(PipeType pipeType) {
        this.pipeType = pipeType;
        return this;
    }

    public PipeBuilder<T> withAsynchronousConfiguration(AsynchronousConfiguration configuration) {
        this.asynchronousConfiguration = configuration;
        return this;
    }

    public PipeBuilder<T> withStatisticsCollector(PipeStatisticsCollector statisticsCollector) {
        this.statisticsCollector = statisticsCollector;
        return this;
    }

    public PipeBuilder<T> withEventListener(PipeEventListener<T> eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public PipeBuilder<T> withErrorHandler(PipeErrorHandler<T> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Pipe<T> build() {
        PipeEventListener<T> eventListener = this.createEventListener();
        CopyOnWriteArrayList subscribers = new CopyOnWriteArrayList();
        if (this.pipeType.equals((Object)PipeType.ASYNCHRONOUS) && this.asynchronousConfiguration == null) {
            throw new IllegalArgumentException("Asynchronous configuration required.");
        }
        TransportMechanism<T> tTransportMechanism = TransportMechanismFactory.transportMechanism(this.pipeType, eventListener, this.errorHandler, subscribers, this.asynchronousConfiguration);
        return new PipeImpl<T>(tTransportMechanism, this.statisticsCollector, subscribers);
    }

    private PipeEventListener<T> createEventListener() {
        if (this.eventListener != null) {
            return this.eventListener;
        }
        return new SimplePipeEventListener(this.statisticsCollector);
    }

    private PipeBuilder() {
    }
}

