/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.internal.reflections;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ReflectionUtils {
    public static List<Method> getAllPublicMethods(Class<?> useCaseClass, Collection<String> excludedMethods) {
        Method[] methods = useCaseClass.getMethods();
        return Arrays.stream(methods).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !Modifier.isAbstract(method.getModifiers())).filter(method -> method.getDeclaringClass().equals(useCaseClass)).filter(method -> !excludedMethods.contains(method.getName())).collect(Collectors.toList());
    }

    private ReflectionUtils() {
    }
}

