/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.internal.correlationIds;

import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.messageBus.internal.correlationIds.CorrelationBasedSubscriptions;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CorrelationBasedSubscriptionsImpl
implements CorrelationBasedSubscriptions {
    private final Map<CorrelationId, List<Subscriber<ProcessingContext<Object>>>> correlationBasedSubscriber = new ConcurrentHashMap<CorrelationId, List<Subscriber<ProcessingContext<Object>>>>();
    private final Map<SubscriptionId, List<CorrelationId>> reverseLookupMap = new ConcurrentHashMap<SubscriptionId, List<CorrelationId>>();

    public static CorrelationBasedSubscriptionsImpl correlationBasedSubscriptions() {
        return new CorrelationBasedSubscriptionsImpl();
    }

    @Override
    public synchronized SubscriptionId addCorrelationBasedSubscriber(CorrelationId correlationId, Subscriber<ProcessingContext<Object>> subscriber) {
        List<Object> correlationIds;
        List<Object> subscribers;
        SubscriptionId subscriptionId = subscriber.getSubscriptionId();
        if (this.correlationBasedSubscriber.containsKey(correlationId)) {
            subscribers = this.correlationBasedSubscriber.get(correlationId);
            subscribers.add(subscriber);
        } else {
            subscribers = new CopyOnWriteArrayList<Subscriber<ProcessingContext<Object>>>();
            ((CopyOnWriteArrayList)subscribers).add(subscriber);
            this.correlationBasedSubscriber.put(correlationId, subscribers);
        }
        if (this.reverseLookupMap.containsKey(subscriptionId)) {
            correlationIds = this.reverseLookupMap.get(subscriptionId);
            correlationIds.add(correlationId);
        } else {
            correlationIds = new LinkedList<CorrelationId>();
            ((LinkedList)correlationIds).add(correlationId);
            this.reverseLookupMap.putIfAbsent(subscriptionId, correlationIds);
        }
        return subscriptionId;
    }

    @Override
    public synchronized void unsubscribe(SubscriptionId subscriptionId) {
        if (this.reverseLookupMap.containsKey(subscriptionId)) {
            List<CorrelationId> correlationIds = this.reverseLookupMap.get(subscriptionId);
            for (CorrelationId correlationId : correlationIds) {
                List<Subscriber<ProcessingContext<Object>>> subscribers = this.correlationBasedSubscriber.get(correlationId);
                subscribers.removeIf(s -> s.getSubscriptionId().equals(subscriptionId));
            }
            if (correlationIds.size() == 1) {
                this.reverseLookupMap.remove(subscriptionId);
            }
        }
    }

    @Override
    public List<Subscriber<ProcessingContext<Object>>> getSubscribersFor(CorrelationId correlationId) {
        if (correlationId == null) {
            return Collections.emptyList();
        }
        return this.correlationBasedSubscriber.getOrDefault(correlationId, Collections.emptyList());
    }

    private CorrelationBasedSubscriptionsImpl() {
    }
}

