/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messageBus.internal.exception;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.internal.exceptions.BubbleUpWrappedException;
import de.quantummaid.eventmaid.messageBus.exception.MessageBusExceptionHandler;
import de.quantummaid.eventmaid.messageBus.exception.MessageBusExceptionListener;
import de.quantummaid.eventmaid.messageBus.internal.exception.ExceptionListenerHandler;
import de.quantummaid.eventmaid.processingContext.ProcessingContext;
import java.util.List;

public final class ErrorListenerDelegatingMessageBusExceptionHandler
implements MessageBusExceptionHandler {
    private final MessageBusExceptionHandler delegate;
    private final ExceptionListenerHandler exceptionListenerHandler;

    public static ErrorListenerDelegatingMessageBusExceptionHandler errorListenerDelegatingMessageBusExceptionHandler(MessageBusExceptionHandler delegate, ExceptionListenerHandler exceptionListenerHandler) {
        return new ErrorListenerDelegatingMessageBusExceptionHandler(delegate, exceptionListenerHandler);
    }

    @Override
    public boolean shouldDeliveryChannelErrorBeHandledAndDeliveryAborted(ProcessingContext<Object> message, Exception e, Channel<Object> channel) {
        return this.delegate.shouldDeliveryChannelErrorBeHandledAndDeliveryAborted(message, e, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDeliveryChannelException(ProcessingContext<Object> message, Exception e, Channel<Object> channel) {
        try {
            this.callDeliveryExceptionHandlerIfNotBubbleUpException(message, e, channel);
        }
        finally {
            this.callTemporaryHandlerIfNotBubbleUpException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFilterException(ProcessingContext<Object> message, Exception e, Channel<Object> channel) {
        try {
            this.callFilterExceptionHandlerIfNotBubbleUpException(message, e, channel);
        }
        finally {
            this.callTemporaryHandlerIfNotBubbleUpException(message, e);
        }
    }

    private void callDeliveryExceptionHandlerIfNotBubbleUpException(ProcessingContext<Object> message, Exception e, Channel<Object> channel) {
        if (e instanceof BubbleUpWrappedException) {
            return;
        }
        try {
            this.delegate.handleDeliveryChannelException(message, e, channel);
        }
        catch (Exception rethrownException) {
            throw new BubbleUpWrappedException(rethrownException);
        }
    }

    private void callFilterExceptionHandlerIfNotBubbleUpException(ProcessingContext<Object> message, Exception e, Channel<Object> channel) {
        if (e instanceof BubbleUpWrappedException) {
            return;
        }
        try {
            this.delegate.handleFilterException(message, e, channel);
        }
        catch (Exception rethrownException) {
            throw new BubbleUpWrappedException(rethrownException);
        }
    }

    private void callTemporaryHandlerIfNotBubbleUpException(ProcessingContext<Object> message, Exception e) {
        if (e instanceof BubbleUpWrappedException) {
            return;
        }
        List<MessageBusExceptionListener> listener = this.exceptionListenerHandler.listenerFor(message);
        this.delegate.callTemporaryExceptionListener(message, e, listener);
    }

    private ErrorListenerDelegatingMessageBusExceptionHandler(MessageBusExceptionHandler delegate, ExceptionListenerHandler exceptionListenerHandler) {
        this.delegate = delegate;
        this.exceptionListenerHandler = exceptionListenerHandler;
    }
}

