/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.qcec.domainBus.internal.answer;

import de.quantummaid.eventmaid.qcec.constraintEnforcing.ConstraintEnforcer;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.Answer;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.SubscriptionIdStorage;
import de.quantummaid.eventmaid.qcec.domainBus.internal.answer.TerminationCondition;
import de.quantummaid.eventmaid.qcec.eventBus.EventBus;
import de.quantummaid.eventmaid.qcec.queryresolving.QueryResolver;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AbstractSharedAnswerImpl<T>
implements Answer {
    protected final SubscriptionIdStorage subscriptionIdStorage = SubscriptionIdStorage.subscriptionIdStorage();
    protected final Class<T> tClass;
    protected final Predicate<T> responseCondition;
    protected final Consumer<T> responseConsumer;
    protected final List<TerminationCondition<?>> terminationConditions;

    @Override
    public SubscriptionId register(QueryResolver queryResolver, ConstraintEnforcer constraintEnforcer, EventBus eventBus) {
        this.executeAnswerSpecificSubscription(this.tClass, queryResolver, constraintEnforcer, eventBus);
        for (TerminationCondition<?> terminationCondition : this.terminationConditions) {
            Class<?> eventClass = terminationCondition.getEventClass();
            Predicate<?> conditionFunction = terminationCondition.getConditionFunction();
            SubscriptionId eventSubscriptionId = eventBus.reactTo(eventClass, o -> {
                if (conditionFunction.test(o)) {
                    this.unregister(queryResolver, constraintEnforcer, eventBus);
                }
            });
            this.subscriptionIdStorage.addEventBusSubscriptionId(eventSubscriptionId);
        }
        return SubscriptionId.newUniqueId();
    }

    protected abstract void executeAnswerSpecificSubscription(Class<T> var1, QueryResolver var2, ConstraintEnforcer var3, EventBus var4);

    @Override
    public void unregister(QueryResolver queryResolver, ConstraintEnforcer constraintEnforcer, EventBus eventBus) {
        List<SubscriptionId> querySubscriptionIds = this.subscriptionIdStorage.getQuerySubscriptionIds();
        for (SubscriptionId subscriptionId : querySubscriptionIds) {
            queryResolver.unsubscribe(subscriptionId);
        }
        List<SubscriptionId> constraintSubscriptionIds = this.subscriptionIdStorage.getConstraintSubscriptionIds();
        for (SubscriptionId constraintSubscriptionId : constraintSubscriptionIds) {
            constraintEnforcer.unsubscribe(constraintSubscriptionId);
        }
        List<SubscriptionId> list = this.subscriptionIdStorage.getEventSubscriptionIds();
        for (SubscriptionId eventSubscriptionId : list) {
            eventBus.unsubscribe(eventSubscriptionId);
        }
    }

    protected AbstractSharedAnswerImpl(Class<T> tClass, Predicate<T> responseCondition, Consumer<T> responseConsumer, List<TerminationCondition<?>> terminationConditions) {
        this.tClass = tClass;
        this.responseCondition = responseCondition;
        this.responseConsumer = responseConsumer;
        this.terminationConditions = terminationConditions;
    }
}

