/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.graph;

import de.quantummaid.httpmaid.chains.graph.Color;
import de.quantummaid.httpmaid.chains.graph.Label;
import de.quantummaid.httpmaid.util.Validators;

public final class Node {
    private final String name;
    private final Label label;
    private final Color color;

    public static Node node(String name) {
        return Node.node(name, Color.BLACK);
    }

    public static Node node(String name, Color color) {
        return Node.node(name, Label.textLabel(name), color);
    }

    public static Node node(String name, Label label, Color color) {
        Validators.validateNotNullNorEmpty(name, "name");
        Validators.validateNotNull(label, "label");
        Validators.validateNotNull(color, "color");
        return new Node(name, label, color);
    }

    String plot() {
        return String.format("%s [label=%s; color=\"%s\"; shape=\"box\"];%n", this.name, this.label.plot(), this.color.color());
    }

    String name() {
        return this.name;
    }

    public String toString() {
        return "Node(name=" + this.name + ", label=" + this.label + ", color=" + this.color + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Label this$label = this.label;
        Label other$label = other.label;
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        Color this$color = this.color;
        Color other$color = other.color;
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Label $label = this.label;
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        Color $color = this.color;
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }

    private Node(String name, Label label, Color color) {
        this.name = name;
        this.label = label;
        this.color = color;
    }
}

