/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ExposedHeader {
    private static final List<ExposedHeader> SIMPLE_RESPONSE_HEADERS = Stream.of("Cache-Control", "Content-Language", "Content-Type", "Expires", "Last-Modified", "Pragma").map(ExposedHeader::exposedHeader).collect(Collectors.toList());
    private final String headerName;

    public static ExposedHeader exposedHeader(String headerName) {
        Validators.validateNotNullNorEmpty(headerName, "headerName");
        String normalized = headerName.toLowerCase();
        return new ExposedHeader(normalized);
    }

    public boolean isSimpleHeader() {
        return SIMPLE_RESPONSE_HEADERS.contains(this);
    }

    public String internalValueForMapping() {
        return this.headerName;
    }

    public String toString() {
        return "ExposedHeader(headerName=" + this.headerName + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExposedHeader)) {
            return false;
        }
        ExposedHeader other = (ExposedHeader)o;
        String this$headerName = this.headerName;
        String other$headerName = other.headerName;
        return !(this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $headerName = this.headerName;
        result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
        return result;
    }

    private ExposedHeader(String headerName) {
        this.headerName = headerName;
    }
}

