/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.events.enriching;

import de.quantummaid.httpmaid.events.enriching.AddMapEntryEnricher;
import de.quantummaid.httpmaid.events.enriching.Enrichable;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EnrichableMap {
    private final Map<String, Enrichable> map;

    public static EnrichableMap emptyEnrichableMap() {
        return new EnrichableMap(new HashMap<String, Enrichable>());
    }

    public static EnrichableMap enrichableMap(List<String> topLevelKeys) {
        Validators.validateNotNull(topLevelKeys, "topLevelKeys");
        HashMap<String, Enrichable> map = new HashMap<String, Enrichable>(topLevelKeys.size());
        topLevelKeys.forEach(key -> map.put((String)key, Enrichable.enrichable(key)));
        return new EnrichableMap(map);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> compiled = new HashMap<String, Object>();
        this.map.forEach((key, enrichable) -> {
            Object value = enrichable.compile();
            compiled.put((String)key, value);
        });
        return compiled;
    }

    public void overwriteTopLevel(Map<String, ?> values) {
        values.forEach(this::overwriteTopLevel);
    }

    public void overwriteTopLevel(String key, Object value) {
        if (!this.map.containsKey(key)) {
            return;
        }
        this.map.get(key).setValue(value);
    }

    public void enrichEitherTopOrSecondLevel(Map<String, ?> values) {
        values.forEach(this::enrichEitherTopOrSecondLevel);
    }

    public void enrichEitherTopOrSecondLevel(String key, Object value) {
        if (this.map.containsKey(key)) {
            this.overwriteTopLevel(key, value);
        } else {
            this.enrichOnSecondLevelWithoutOverwriting(key, value);
        }
    }

    public void enrichOnSecondLevelWithoutOverwriting(String key, Object value) {
        this.map.values().forEach(enrichable -> EnrichableMap.enrichWithoutOverwriting(key, value, enrichable));
    }

    public void enrichOnSecondLevelWithOverwriting(String key, Object value) {
        this.map.values().forEach(enrichable -> EnrichableMap.enrichWithOverwriting(key, value, enrichable));
    }

    private static void enrichWithoutOverwriting(String key, Object value, Enrichable enrichable) {
        enrichable.enrichWithoutOverwrite(AddMapEntryEnricher.mapEntry(key, value));
    }

    private static void enrichWithOverwriting(String key, Object value, Enrichable enrichable) {
        enrichable.enrichWithOverwrite(AddMapEntryEnricher.mapEntry(key, value));
    }

    public String toString() {
        return "EnrichableMap(map=" + this.map + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnrichableMap)) {
            return false;
        }
        EnrichableMap other = (EnrichableMap)o;
        Map<String, Enrichable> this$map = this.map;
        Map<String, Enrichable> other$map = other.map;
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Enrichable> $map = this.map;
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    private EnrichableMap(Map<String, Enrichable> map) {
        this.map = map;
    }
}

