/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.distribution;

import de.quantummaid.httpmaid.handler.distribution.DistributableHandler;
import de.quantummaid.httpmaid.handler.distribution.DistributerAndFollowUps;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.function.Predicate;

public final class HandlerDistributor {
    private final Predicate<DistributableHandler> predicate;
    private final DistributerAndFollowUps distributerAndFollowUps;

    public static HandlerDistributor handlerDistributor(Predicate<DistributableHandler> predicate, DistributerAndFollowUps distributerAndFollowUps) {
        Validators.validateNotNull(predicate, "predicate");
        Validators.validateNotNull(distributerAndFollowUps, "distributerAndFollowUps");
        return new HandlerDistributor(predicate, distributerAndFollowUps);
    }

    public boolean appliesTo(DistributableHandler handler) {
        return this.predicate.test(handler);
    }

    public List<DistributableHandler> distributeAndProvideFollowUps(DistributableHandler handler) {
        return this.distributerAndFollowUps.distribute(handler);
    }

    public String toString() {
        return "HandlerDistributor(predicate=" + this.predicate + ", distributerAndFollowUps=" + this.distributerAndFollowUps + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerDistributor)) {
            return false;
        }
        HandlerDistributor other = (HandlerDistributor)o;
        Predicate<DistributableHandler> this$predicate = this.predicate;
        Predicate<DistributableHandler> other$predicate = other.predicate;
        if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
            return false;
        }
        DistributerAndFollowUps this$distributerAndFollowUps = this.distributerAndFollowUps;
        DistributerAndFollowUps other$distributerAndFollowUps = other.distributerAndFollowUps;
        return !(this$distributerAndFollowUps == null ? other$distributerAndFollowUps != null : !this$distributerAndFollowUps.equals(other$distributerAndFollowUps));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<DistributableHandler> $predicate = this.predicate;
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        DistributerAndFollowUps $distributerAndFollowUps = this.distributerAndFollowUps;
        result = result * 59 + ($distributerAndFollowUps == null ? 43 : $distributerAndFollowUps.hashCode());
        return result;
    }

    private HandlerDistributor(Predicate<DistributableHandler> predicate, DistributerAndFollowUps distributerAndFollowUps) {
        this.predicate = predicate;
        this.distributerAndFollowUps = distributerAndFollowUps;
    }
}

