/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.PathParameterKey;
import de.quantummaid.httpmaid.http.PathParameterValue;
import de.quantummaid.httpmaid.util.Maps;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;
import java.util.Optional;

public final class PathParameters {
    private final Map<PathParameterKey, PathParameterValue> pathParameters;

    public static PathParameters pathParameters(Map<String, String> stringMap) {
        Validators.validateNotNull(stringMap, "stringMap");
        Map<PathParameterKey, PathParameterValue> pathParameters = Maps.stringsToValueObjects(stringMap, PathParameterKey::pathParameterKey, PathParameterValue::pathParameterValue);
        return new PathParameters(pathParameters);
    }

    public String getPathParameter(String key) {
        return this.getOptionalPathParameter(key).orElseThrow(() -> new RuntimeException(String.format("No path parameter with the key '%s'", key)));
    }

    public Optional<String> getOptionalPathParameter(String key) {
        PathParameterKey pathParameterKey = PathParameterKey.pathParameterKey(key);
        return Maps.getOptionally(this.pathParameters, pathParameterKey).map(PathParameterValue::stringValue);
    }

    public Map<String, String> asStringMap() {
        return Maps.valueObjectsToStrings(this.pathParameters, PathParameterKey::stringValue, PathParameterValue::stringValue);
    }

    public String toString() {
        return "PathParameters(pathParameters=" + this.pathParameters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathParameters)) {
            return false;
        }
        PathParameters other = (PathParameters)o;
        Map<PathParameterKey, PathParameterValue> this$pathParameters = this.pathParameters;
        Map<PathParameterKey, PathParameterValue> other$pathParameters = other.pathParameters;
        return !(this$pathParameters == null ? other$pathParameters != null : !((Object)this$pathParameters).equals(other$pathParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<PathParameterKey, PathParameterValue> $pathParameters = this.pathParameters;
        result = result * 59 + ($pathParameters == null ? 43 : ((Object)$pathParameters).hashCode());
        return result;
    }

    private PathParameters(Map<PathParameterKey, PathParameterValue> pathParameters) {
        this.pathParameters = pathParameters;
    }
}

