/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.QueryParameterKey;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.util.Maps;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Map;
import java.util.Optional;

public final class QueryParameters {
    private final Map<QueryParameterKey, QueryParameterValue> queryParameters;

    public static QueryParameters queryParameters(Map<String, String> stringMap) {
        Validators.validateNotNull(stringMap, "stringMap");
        Map<QueryParameterKey, QueryParameterValue> queryParameters = Maps.stringsToValueObjects(stringMap, QueryParameterKey::queryParameterKey, QueryParameterValue::queryParameterValue);
        return new QueryParameters(queryParameters);
    }

    public String getQueryParameter(String key) {
        return this.getOptionalQueryParameter(key).orElseThrow(() -> new RuntimeException(String.format("No query parameter with the key '%s'", key)));
    }

    public Optional<String> getOptionalQueryParameter(String key) {
        QueryParameterKey queryParameterKey = QueryParameterKey.queryParameterKey(key);
        return Maps.getOptionally(this.queryParameters, queryParameterKey).map(QueryParameterValue::stringValue);
    }

    public Map<String, String> asStringMap() {
        return Maps.valueObjectsToStrings(this.queryParameters, QueryParameterKey::stringValue, QueryParameterValue::stringValue);
    }

    public String toString() {
        return "QueryParameters(queryParameters=" + this.queryParameters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryParameters)) {
            return false;
        }
        QueryParameters other = (QueryParameters)o;
        Map<QueryParameterKey, QueryParameterValue> this$queryParameters = this.queryParameters;
        Map<QueryParameterKey, QueryParameterValue> other$queryParameters = other.queryParameters;
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<QueryParameterKey, QueryParameterValue> $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    private QueryParameters(Map<QueryParameterKey, QueryParameterValue> queryParameters) {
        this.queryParameters = queryParameters;
    }
}

