/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.logger;

import de.quantummaid.httpmaid.logger.LogMessage;
import de.quantummaid.httpmaid.logger.LoggerImplementation;
import java.io.PrintStream;

public final class Loggers {
    private Loggers() {
    }

    public static LoggerImplementation stderrLogger() {
        return Loggers.logTo(System.err);
    }

    public static LoggerImplementation stdoutLogger() {
        return Loggers.logTo(System.out);
    }

    public static LoggerImplementation logTo(PrintStream printStream) {
        return message -> Loggers.writeTo(printStream, message);
    }

    public static LoggerImplementation stdoutAndStderrLogger() {
        return message -> {
            if (message.hasException()) {
                Loggers.writeTo(System.err, message);
            } else {
                Loggers.writeTo(System.out, message);
            }
        };
    }

    public static LoggerImplementation noLogger() {
        return message -> {};
    }

    private static void writeTo(PrintStream printStream, LogMessage message) {
        String formattedMessage = message.formattedMessage();
        printStream.println(formattedMessage);
    }
}

