/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid;

import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.MarshallingModule;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.mapmaid.MapMaid;
import de.quantummaid.mapmaid.builder.recipes.marshallers.urlencoded.UrlEncodedMarshallerRecipe;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MapMaidMarshallingMapper {
    private static final Map<MarshallingType, ContentType> DEFAULT_CONTENT_TYPE_MAPPINGS = Map.of(MarshallingType.json(), ContentType.json(), MarshallingType.xml(), ContentType.xml(), MarshallingType.yaml(), ContentType.yaml(), UrlEncodedMarshallerRecipe.urlEncoded(), ContentType.formUrlEncoded());
    private static final List<MarshallingType> DEFAULT_SUPPORTED_TYPES_FOR_UNMARSHALLING = Arrays.asList(MarshallingType.json(), MarshallingType.xml(), MarshallingType.yaml(), UrlEncodedMarshallerRecipe.urlEncoded());
    private static final List<MarshallingType> DEFAULT_SUPPORTED_TYPES_FOR_MARSHALLING = Arrays.asList(MarshallingType.json(), MarshallingType.xml(), MarshallingType.yaml());
    private final Map<ContentType, MarshallingType> contentTypeMappingsForUnmarshalling = new HashMap<ContentType, MarshallingType>();
    private final Map<ContentType, MarshallingType> contentTypeMappingsForMarshalling = new HashMap<ContentType, MarshallingType>();

    static MapMaidMarshallingMapper mapMaidMarshallingMapper() {
        return new MapMaidMarshallingMapper();
    }

    void addRequestContentTypeToUnmarshallingTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshallingType, "marshallingType");
        this.contentTypeMappingsForUnmarshalling.put(contentType, marshallingType);
    }

    void addMarshallingTypeToResponseContentTypeMapping(ContentType contentType, MarshallingType marshallingType) {
        Validators.validateNotNull(contentType, "contentType");
        Validators.validateNotNull(marshallingType, "marshallingType");
        this.contentTypeMappingsForMarshalling.put(contentType, marshallingType);
    }

    void mapMarshalling(MapMaid mapMaid, MarshallingModule marshallingModule) {
        mapMaid.deserializer().supportedMarshallingTypes().stream().filter(marshallingType -> !this.contentTypeMappingsForUnmarshalling.containsValue(marshallingType)).filter(DEFAULT_SUPPORTED_TYPES_FOR_UNMARSHALLING::contains).forEach(marshallingType -> {
            ContentType contentType = DEFAULT_CONTENT_TYPE_MAPPINGS.get(marshallingType);
            this.contentTypeMappingsForUnmarshalling.put(contentType, (MarshallingType)marshallingType);
        });
        this.contentTypeMappingsForUnmarshalling.forEach((contentType, marshallingType) -> marshallingModule.addUnmarshaller((ContentType)contentType, input -> mapMaid.deserializer().deserializeToUniversalObject(input, (MarshallingType)marshallingType)));
        mapMaid.serializer().supportedMarshallingTypes().stream().filter(marshallingType -> !this.contentTypeMappingsForMarshalling.containsValue(marshallingType)).filter(DEFAULT_SUPPORTED_TYPES_FOR_MARSHALLING::contains).forEach(marshallingType -> {
            ContentType contentType = DEFAULT_CONTENT_TYPE_MAPPINGS.get(marshallingType);
            this.contentTypeMappingsForMarshalling.put(contentType, (MarshallingType)marshallingType);
        });
        this.contentTypeMappingsForMarshalling.forEach((contentType, marshallingType) -> marshallingModule.addMarshaller((ContentType)contentType, map -> mapMaid.serializer().serializeFromUniversalObject(map, (MarshallingType)marshallingType)));
        if (mapMaid.deserializer().supportedMarshallingTypes().contains(MarshallingType.JSON)) {
            marshallingModule.setDefaultContentType(ContentType.json());
        }
    }

    public String toString() {
        return "MapMaidMarshallingMapper(contentTypeMappingsForUnmarshalling=" + this.contentTypeMappingsForUnmarshalling + ", contentTypeMappingsForMarshalling=" + this.contentTypeMappingsForMarshalling + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaidMarshallingMapper)) {
            return false;
        }
        MapMaidMarshallingMapper other = (MapMaidMarshallingMapper)o;
        Map<ContentType, MarshallingType> this$contentTypeMappingsForUnmarshalling = this.contentTypeMappingsForUnmarshalling;
        Map<ContentType, MarshallingType> other$contentTypeMappingsForUnmarshalling = other.contentTypeMappingsForUnmarshalling;
        if (this$contentTypeMappingsForUnmarshalling == null ? other$contentTypeMappingsForUnmarshalling != null : !((Object)this$contentTypeMappingsForUnmarshalling).equals(other$contentTypeMappingsForUnmarshalling)) {
            return false;
        }
        Map<ContentType, MarshallingType> this$contentTypeMappingsForMarshalling = this.contentTypeMappingsForMarshalling;
        Map<ContentType, MarshallingType> other$contentTypeMappingsForMarshalling = other.contentTypeMappingsForMarshalling;
        return !(this$contentTypeMappingsForMarshalling == null ? other$contentTypeMappingsForMarshalling != null : !((Object)this$contentTypeMappingsForMarshalling).equals(other$contentTypeMappingsForMarshalling));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ContentType, MarshallingType> $contentTypeMappingsForUnmarshalling = this.contentTypeMappingsForUnmarshalling;
        result = result * 59 + ($contentTypeMappingsForUnmarshalling == null ? 43 : ((Object)$contentTypeMappingsForUnmarshalling).hashCode());
        Map<ContentType, MarshallingType> $contentTypeMappingsForMarshalling = this.contentTypeMappingsForMarshalling;
        result = result * 59 + ($contentTypeMappingsForMarshalling == null ? 43 : ((Object)$contentTypeMappingsForMarshalling).hashCode());
        return result;
    }

    private MapMaidMarshallingMapper() {
    }
}

