/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mapmaid.advancedscanner;

import de.quantummaid.mapmaid.mapper.deserialization.DeserializationFields;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.HashMap;
import java.util.Map;

public final class VirtualDeserializer
implements SerializedObjectDeserializer {
    private final String method;
    private final DeserializationFields deserializationFields;

    public static SerializedObjectDeserializer virtualDeserializerFor(String method, Map<String, ResolvedType> parameters) {
        HashMap<String, TypeIdentifier> fieldMap = new HashMap<String, TypeIdentifier>();
        parameters.forEach((name, type) -> fieldMap.put((String)name, TypeIdentifier.typeIdentifierFor(GenericType.fromResolvedType(type))));
        DeserializationFields deserializationFields = DeserializationFields.deserializationFields(fieldMap);
        return new VirtualDeserializer(method, deserializationFields);
    }

    @Override
    public DeserializationFields fields() {
        return this.deserializationFields;
    }

    @Override
    public Object deserialize(Map<String, Object> elements) {
        return elements;
    }

    @Override
    public String description() {
        return String.format("virtual deserializer for the invocation of '%s'", this.method);
    }

    public String toString() {
        return "VirtualDeserializer(method=" + this.method + ", deserializationFields=" + this.deserializationFields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualDeserializer)) {
            return false;
        }
        VirtualDeserializer other = (VirtualDeserializer)o;
        String this$method = this.method;
        String other$method = other.method;
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        DeserializationFields this$deserializationFields = this.deserializationFields;
        DeserializationFields other$deserializationFields = other.deserializationFields;
        return !(this$deserializationFields == null ? other$deserializationFields != null : !((Object)this$deserializationFields).equals(other$deserializationFields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        DeserializationFields $deserializationFields = this.deserializationFields;
        result = result * 59 + ($deserializationFields == null ? 43 : ((Object)$deserializationFields).hashCode());
        return result;
    }

    private VirtualDeserializer(String method, DeserializationFields deserializationFields) {
        this.method = method;
        this.deserializationFields = deserializationFields;
    }
}

