/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.urlencoded;

import de.quantummaid.httpmaid.marshalling.Unmarshaller;
import de.quantummaid.httpmaid.marshalling.urlencoded.Key;
import de.quantummaid.httpmaid.marshalling.urlencoded.KeyElement;
import de.quantummaid.httpmaid.marshalling.urlencoded.ParsedUrlEncoded;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class UrlEncodedUnmarshaller
implements Unmarshaller {
    public static Unmarshaller urlEncodedUnmarshaller() {
        return new UrlEncodedUnmarshaller();
    }

    @Override
    public Map<String, Object> unmarshall(String string) {
        ParsedUrlEncoded parsed = ParsedUrlEncoded.parse(string);
        return (Map)this.parseFromKey(Key.emptyKey(), parsed);
    }

    private Object parseFromKey(Key key, ParsedUrlEncoded parsed) {
        return parsed.getValue(key).map(string -> string).orElseGet(() -> this.parseArrayOrMap(key, parsed));
    }

    private Object parseArrayOrMap(Key key, ParsedUrlEncoded parsed) {
        List<KeyElement> children = parsed.directChildren(key);
        if (UrlEncodedUnmarshaller.areArrayIndeces(children)) {
            return this.parseArray(key, children, parsed);
        }
        return this.parseMap(key, children, parsed);
    }

    private List<Object> parseArray(Key key, List<KeyElement> children, ParsedUrlEncoded parsed) {
        LinkedList<Object> list = new LinkedList<Object>();
        children.forEach(child -> {
            Object childValue = this.parseFromKey(key.child((KeyElement)child), parsed);
            list.add(child.asArrayIndex(), childValue);
        });
        return list;
    }

    private Map<String, Object> parseMap(Key key, List<KeyElement> children, ParsedUrlEncoded parsed) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        children.forEach(child -> {
            Object childValue = this.parseFromKey(key.child((KeyElement)child), parsed);
            map.put(child.value(), childValue);
        });
        return map;
    }

    private static boolean areArrayIndeces(List<KeyElement> indeces) {
        return indeces.stream().anyMatch(KeyElement::isArrayIndex);
    }

    public String toString() {
        return "UrlEncodedUnmarshaller()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof UrlEncodedUnmarshaller;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private UrlEncodedUnmarshaller() {
    }
}

