/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;

public final class SecurityProcessor
implements Processor {
    private final Processor processor;
    private final ChainName chainName;
    private final List<Filter> filters;

    public static SecurityProcessor securityProcessor(Processor processor, ChainName chainName, List<Filter> filters) {
        Validators.validateNotNull(processor, "processor");
        Validators.validateNotNull(chainName, "chainName");
        Validators.validateNotNull(filters, "filters");
        return new SecurityProcessor(processor, chainName, filters);
    }

    ChainName chainName() {
        return this.chainName;
    }

    @Override
    public void apply(MetaData metaData) {
        HttpRequest request = HttpRequest.httpRequest(metaData);
        for (Filter filter : this.filters) {
            if (filter.filter(request)) continue;
            return;
        }
        this.processor.apply(metaData);
    }

    public String toString() {
        return "SecurityProcessor(processor=" + this.processor + ", chainName=" + this.chainName + ", filters=" + this.filters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProcessor)) {
            return false;
        }
        SecurityProcessor other = (SecurityProcessor)o;
        Processor this$processor = this.processor;
        Processor other$processor = other.processor;
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        ChainName this$chainName = this.chainName;
        ChainName other$chainName = other.chainName;
        if (this$chainName == null ? other$chainName != null : !((Object)this$chainName).equals(other$chainName)) {
            return false;
        }
        List<Filter> this$filters = this.filters;
        List<Filter> other$filters = other.filters;
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Processor $processor = this.processor;
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        ChainName $chainName = this.chainName;
        result = result * 59 + ($chainName == null ? 43 : ((Object)$chainName).hashCode());
        List<Filter> $filters = this.filters;
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    private SecurityProcessor(Processor processor, ChainName chainName, List<Filter> filters) {
        this.processor = processor;
        this.chainName = chainName;
        this.filters = filters;
    }
}

