/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.authorization;

import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AuthorizationHeader {
    private static final Pattern PATTERN = Pattern.compile("(?<type>\\S*) (?<credentials>\\S*)");
    private final String type;
    private final String credentials;

    public static Optional<AuthorizationHeader> parse(String header) {
        Validators.validateNotNullNorEmpty(header, "header");
        Matcher matcher = PATTERN.matcher(header);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String type = matcher.group("type");
        String credentials = matcher.group("credentials");
        return Optional.of(new AuthorizationHeader(type, credentials));
    }

    public String type() {
        return this.type;
    }

    public String credentials() {
        return this.credentials;
    }

    public String toString() {
        return "AuthorizationHeader(type=" + this.type + ", credentials=" + this.credentials + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizationHeader)) {
            return false;
        }
        AuthorizationHeader other = (AuthorizationHeader)o;
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$credentials = this.credentials;
        String other$credentials = other.credentials;
        return !(this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $credentials = this.credentials;
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        return result;
    }

    private AuthorizationHeader(String type, String credentials) {
        this.type = type;
        this.credentials = credentials;
    }
}

