/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.usecases.method;

import de.quantummaid.eventmaid.internal.reflections.ForbiddenUseCaseMethods;
import de.quantummaid.eventmaid.useCases.useCaseAdapter.methodInvoking.MethodInvocationException;
import de.quantummaid.httpmaid.usecases.method.Parameters;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class UseCaseMethod {
    private final ResolvedType useCaseClass;
    private final ResolvedMethod method;
    private final Parameters parameters;

    public static UseCaseMethod useCaseMethodOf(ResolvedType useCase) throws IllegalArgumentException {
        UseCaseMethod.validateUseCaseClass(useCase);
        ResolvedMethod method = UseCaseMethod.locateUseCaseMethod((ClassType)useCase);
        if (method.method().getTypeParameters().length != 0) {
            throw new IllegalArgumentException(String.format("use case method '%s' in class '%s' must not declare any type variables", method.describe(), useCase.simpleDescription()));
        }
        Parameters parameters = Parameters.parametersOf(method);
        return new UseCaseMethod(useCase, method, parameters);
    }

    public ResolvedType useCaseClass() {
        return this.useCaseClass;
    }

    public boolean isSingleParameterUseCase() {
        return this.parameters.asMap().size() == 1;
    }

    public String singleParameterName() {
        return this.parameterNames().get(0);
    }

    public List<String> parameterNames() {
        return this.parameters.names();
    }

    public Map<String, ResolvedType> parameters() {
        return this.parameters.asMap();
    }

    public Optional<ResolvedType> returnType() {
        return this.method.returnType();
    }

    public String describe() {
        return this.method.describe();
    }

    public Optional<Object> invoke(Object useCase, Map<String, Object> parameters, Object event) throws Exception {
        Object[] parameterInstances = this.parameters.toArray(parameters);
        try {
            Object returnValue = this.method.method().invoke(useCase, parameterInstances);
            return Optional.ofNullable(returnValue);
        }
        catch (IllegalAccessException e) {
            Class<?> useCaseClass = useCase.getClass();
            throw MethodInvocationException.methodInvocationException(useCaseClass, useCase, this.method.method(), event, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (this.isDeclaredByMethod(cause, this.method.method())) {
                throw (Exception)cause;
            }
            Class<?> useCaseClass = useCase.getClass();
            throw MethodInvocationException.methodInvocationException(useCaseClass, useCase, this.method.method(), event, e);
        }
    }

    private boolean isDeclaredByMethod(Throwable cause, Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class<?> exceptionClass = cause.getClass();
        return Arrays.asList(exceptionTypes).contains(exceptionClass);
    }

    private static ResolvedMethod locateUseCaseMethod(ClassType useCaseClass) {
        List<ResolvedMethod> useCaseMethods = UseCaseMethod.getAllPublicMethods(useCaseClass, ForbiddenUseCaseMethods.NOT_ALLOWED_USECASE_PUBLIC_METHODS);
        if (useCaseMethods.size() == 1) {
            return useCaseMethods.get(0);
        }
        String methods = useCaseMethods.stream().map(ResolvedMethod::describe).collect(Collectors.joining(", ", "[", "]"));
        String message = String.format("Use case classes must have exactly one public instance (non-static) method. Found the methods %s for class '%s'. (Note that methods that declare new type variables (\"generics\") are not taken into account)", methods, useCaseClass.description());
        throw new IllegalArgumentException(message);
    }

    private static List<ResolvedMethod> getAllPublicMethods(ClassType useCaseClass, Collection<String> excludedMethods) {
        return useCaseClass.methods().stream().filter(ResolvedMethod::isPublic).filter(method -> !Modifier.isStatic(method.method().getModifiers())).filter(method -> !Modifier.isAbstract(method.method().getModifiers())).filter(method -> method.method().getDeclaringClass().equals(useCaseClass.assignableType())).filter(method -> !excludedMethods.contains(method.name())).collect(Collectors.toList());
    }

    private static void validateUseCaseClass(ResolvedType useCase) {
        UseCaseMethod.validateNotAnonymousClass(useCase);
        UseCaseMethod.validateNotLocalClass(useCase);
        UseCaseMethod.validatePublicClass(useCase);
        UseCaseMethod.validateNotPrimitiveClass(useCase);
        UseCaseMethod.validateNotArrayClass(useCase);
        UseCaseMethod.validateNotAnnotationClass(useCase);
        UseCaseMethod.validateNotEnumClass(useCase);
        UseCaseMethod.validateNotInnerClass(useCase);
    }

    private static void validateNotAnonymousClass(ResolvedType useCase) {
        if (useCase.isAnonymousClass()) {
            throw new IllegalArgumentException(String.format("use case must not be an anonymous class but got '%s'", useCase.description()));
        }
    }

    private static void validateNotLocalClass(ResolvedType useCase) {
        if (useCase.isLocalClass()) {
            throw new IllegalArgumentException(String.format("use case must not be a local class but got '%s'", useCase.description()));
        }
    }

    private static void validatePublicClass(ResolvedType useCase) {
        if (!useCase.isPublic()) {
            throw new IllegalArgumentException(String.format("use case class must be public but got '%s'", useCase.description()));
        }
    }

    private static void validateNotPrimitiveClass(ResolvedType useCase) {
        if (useCase.assignableType().isPrimitive()) {
            throw new IllegalArgumentException(String.format("use case must not be a primitive but got '%s'", useCase.description()));
        }
    }

    private static void validateNotArrayClass(ResolvedType useCase) {
        if (useCase.assignableType().isArray()) {
            throw new IllegalArgumentException(String.format("use case must not be an array but got '%s'", useCase.description()));
        }
    }

    private static void validateNotAnnotationClass(ResolvedType useCase) {
        if (useCase.isAnnotation()) {
            throw new IllegalArgumentException(String.format("use case must not be an annotation but got '%s'", useCase.description()));
        }
    }

    private static void validateNotEnumClass(ResolvedType useCase) {
        if (useCase.assignableType().isEnum()) {
            throw new IllegalArgumentException(String.format("use case must not be an enum but got '%s'", useCase.description()));
        }
    }

    private static void validateNotInnerClass(ResolvedType useCase) {
        if (useCase.isInnerClass()) {
            throw new IllegalArgumentException(String.format("use case must not be an inner class but got '%s'", useCase.description()));
        }
    }

    public String toString() {
        return "UseCaseMethod(useCaseClass=" + this.useCaseClass + ", method=" + this.method + ", parameters=" + this.parameters + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseMethod)) {
            return false;
        }
        UseCaseMethod other = (UseCaseMethod)o;
        ResolvedType this$useCaseClass = this.useCaseClass;
        ResolvedType other$useCaseClass = other.useCaseClass;
        if (this$useCaseClass == null ? other$useCaseClass != null : !this$useCaseClass.equals(other$useCaseClass)) {
            return false;
        }
        ResolvedMethod this$method = this.method;
        ResolvedMethod other$method = other.method;
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Parameters this$parameters = this.parameters;
        Parameters other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $useCaseClass = this.useCaseClass;
        result = result * 59 + ($useCaseClass == null ? 43 : $useCaseClass.hashCode());
        ResolvedMethod $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Parameters $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    private UseCaseMethod(ResolvedType useCaseClass, ResolvedMethod method, Parameters parameters) {
        this.useCaseClass = useCaseClass;
        this.method = method;
        this.parameters = parameters;
    }
}

