/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization;

import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.CustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByMethodDeserializer;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class StaticMethodBasedCustomPrimitiveDeserializationDetector
implements CustomPrimitiveDeserializationDetector {
    private final CustomPrimitiveMappings mappings;

    public static CustomPrimitiveDeserializationDetector staticMethodBased(CustomPrimitiveMappings mappings) {
        NotNullValidator.validateNotNull(mappings, "mappings");
        return new StaticMethodBasedCustomPrimitiveDeserializationDetector(mappings);
    }

    @Override
    public List<TypeDeserializer> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        return this.findDeserializerMethod((ClassType)type).stream().map(method -> CustomPrimitiveByMethodDeserializer.createDeserializer(type, method)).collect(Collectors.toList());
    }

    private List<ResolvedMethod> findDeserializerMethod(ClassType type) {
        return type.methods().stream().filter(method -> Modifier.isStatic(method.method().getModifiers())).filter(method -> method.returnType().isPresent()).filter(method -> method.returnType().get().equals(type)).filter(method -> method.parameters().size() == 1).filter(method -> this.mappings.isPrimitiveType(method.parameters().get(0).type().assignableType())).collect(Collectors.toList());
    }

    public String toString() {
        return "StaticMethodBasedCustomPrimitiveDeserializationDetector(mappings=" + this.mappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticMethodBasedCustomPrimitiveDeserializationDetector)) {
            return false;
        }
        StaticMethodBasedCustomPrimitiveDeserializationDetector other = (StaticMethodBasedCustomPrimitiveDeserializationDetector)o;
        CustomPrimitiveMappings this$mappings = this.mappings;
        CustomPrimitiveMappings other$mappings = other.mappings;
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomPrimitiveMappings $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    private StaticMethodBasedCustomPrimitiveDeserializationDetector(CustomPrimitiveMappings mappings) {
        this.mappings = mappings;
    }
}

