/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.customprimitive.serialization;

import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.CustomPrimitiveSerializationDetector;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.MethodCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class MethodBasedCustomPrimitiveSerializationDetector
implements CustomPrimitiveSerializationDetector {
    private final CustomPrimitiveMappings mappings;

    public static CustomPrimitiveSerializationDetector methodBased(CustomPrimitiveMappings mappings) {
        NotNullValidator.validateNotNull(mappings, "mappings");
        return new MethodBasedCustomPrimitiveSerializationDetector(mappings);
    }

    @Override
    public List<TypeSerializer> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        List<TypeSerializer> serializers = ((ClassType)type).methods().stream().filter(method -> !Modifier.isStatic(method.method().getModifiers())).filter(method -> method.returnType().isPresent()).filter(method -> this.mappings.isPrimitiveType(method.returnType().get().assignableType())).filter(method -> method.parameters().size() == 0).map(method -> MethodCustomPrimitiveSerializer.createSerializer(type, method)).collect(Collectors.toList());
        return serializers;
    }

    public String toString() {
        return "MethodBasedCustomPrimitiveSerializationDetector(mappings=" + this.mappings + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodBasedCustomPrimitiveSerializationDetector)) {
            return false;
        }
        MethodBasedCustomPrimitiveSerializationDetector other = (MethodBasedCustomPrimitiveSerializationDetector)o;
        CustomPrimitiveMappings this$mappings = this.mappings;
        CustomPrimitiveMappings other$mappings = other.mappings;
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomPrimitiveMappings $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    private MethodBasedCustomPrimitiveSerializationDetector(CustomPrimitiveMappings mappings) {
        this.mappings = mappings;
    }
}

