/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization;

import de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization.SerializedObjectDeserializationDetector;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MultipleMethodsSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedConstructor;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SetterBasedDeserializationDetector
implements SerializedObjectDeserializationDetector {
    public static SerializedObjectDeserializationDetector setterBasedDeserializationDetector() {
        return new SetterBasedDeserializationDetector();
    }

    @Override
    public List<SerializedObjectDeserializer> detect(ResolvedType type) {
        if (!(type instanceof ClassType)) {
            return Collections.emptyList();
        }
        ClassType classType = (ClassType)type;
        Optional<ResolvedConstructor> zeroArgumentsConstructor = classType.constructors().stream().filter(resolvedConstructor -> resolvedConstructor.parameters().isEmpty()).findAny();
        if (zeroArgumentsConstructor.isEmpty()) {
            return Collections.emptyList();
        }
        List<ResolvedMethod> setterMethods = classType.methods().stream().filter(resolvedMethod -> resolvedMethod.method().getName().startsWith("set")).filter(resolvedMethod -> resolvedMethod.returnType().isEmpty()).filter(resolvedMethod -> resolvedMethod.parameters().size() == 1).collect(Collectors.toList());
        if (setterMethods.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, ResolvedMethod> fieldMap = new HashMap<String, ResolvedMethod>();
        setterMethods.forEach(resolvedMethod -> {
            String name = SetterBasedDeserializationDetector.extractSetterFieldName(resolvedMethod.method().getName());
            fieldMap.put(name, (ResolvedMethod)resolvedMethod);
        });
        return List.of(MultipleMethodsSerializedObjectDeserializer.multipleMethodsSerializedObjectDeserializer(zeroArgumentsConstructor.get(), fieldMap));
    }

    private static String extractSetterFieldName(String methodName) {
        String withoutGet = methodName.substring(3);
        String firstCharacter = String.valueOf(withoutGet.charAt(0));
        String lowercaseFirstCharacter = firstCharacter.toLowerCase(Locale.US);
        return lowercaseFirstCharacter + withoutGet.substring(1);
    }

    public String toString() {
        return "SetterBasedDeserializationDetector()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof SetterBasedDeserializationDetector;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private SetterBasedDeserializationDetector() {
    }
}

